/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.model.Condition;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;

public final class BetweenCondition
extends Condition {
    private final Model first;
    private final Model second;
    private final Model third;

    private BetweenCondition(Model first, Model second, Model third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static BetweenCondition between(Model first, Model second, Model third) {
        AssertUtils.notNull(first, "between\u6761\u4ef6\u7684\u7b2c\u4e00\u4e2a\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(first, "between\u6761\u4ef6\u7684\u7b2c\u4e8c\u4e2a\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(first, "between\u6761\u4ef6\u7684\u7b2c\u4e09\u4e2a\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        return new BetweenCondition(first, second, third);
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        return this.first.getDatabaseSql(databaseType) + " BETWEEN " + this.second.getDatabaseSql(databaseType) + " AND " + this.third.getDatabaseSql(databaseType);
    }

    public Model getFirst() {
        return this.first;
    }

    public Model getSecond() {
        return this.second;
    }

    public Model getThird() {
        return this.third;
    }
}

