/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.Op;
import com.sensesai.sql.model.Condition;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;

public final class BinaryCondition
extends Condition {
    private final Op op;
    private final Model left;
    private final Model right;

    private BinaryCondition(Op op, Model left, Model right) {
        AssertUtils.notNull((Object)op, "\u6761\u4ef6\u5339\u914d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(left, op.getCode() + "\u6761\u4ef6\u5de6\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        if (op != Op.IS_NULL && op != Op.NOT_NULL) {
            AssertUtils.notNull(right, op.getCode() + "\u6761\u4ef6\u53f3\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public static BinaryCondition lessThan(Model left, Model right) {
        return new BinaryCondition(Op.LESS_THAN, left, right);
    }

    public static BinaryCondition lessThanOrEqual(Model left, Model right) {
        return new BinaryCondition(Op.LESS_THAN_OR_EQUAL, left, right);
    }

    public static BinaryCondition greaterThan(Model left, Model right) {
        return new BinaryCondition(Op.GREATER_THAN, left, right);
    }

    public static BinaryCondition greaterThanOrEqual(Model left, Model right) {
        return new BinaryCondition(Op.GREATER_THAN_OR_EQUAL, left, right);
    }

    public static BinaryCondition equal(Model left, Model right) {
        return new BinaryCondition(Op.EQUAL, left, right);
    }

    public static BinaryCondition notEqual(Model left, Model right) {
        return new BinaryCondition(Op.NOT_EQUAL, left, right);
    }

    public static BinaryCondition like(Model left, Model right) {
        return new BinaryCondition(Op.LIKE, left, right);
    }

    public static BinaryCondition notLike(Model left, Model right) {
        return new BinaryCondition(Op.NOT_LIKE, left, right);
    }

    public static BinaryCondition isNull(Model left) {
        return new BinaryCondition(Op.IS_NULL, left, null);
    }

    public static BinaryCondition isNotNull(Model left) {
        return new BinaryCondition(Op.NOT_NULL, left, null);
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        return this.left.getDatabaseSql(databaseType) + " " + this.op.getCode() + " " + (this.right == null ? "" : this.right.getDatabaseSql(databaseType));
    }

    public Op getOp() {
        return this.op;
    }

    public Model getLeft() {
        return this.left;
    }

    public Model getRight() {
        return this.right;
    }
}

