/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.CustomSql;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;
import java.util.ArrayList;
import java.util.List;

public class Case
implements Model {
    private final List<Model> whenValue = new ArrayList<Model>();
    private final List<Model> thenValue = new ArrayList<Model>();
    private Model elseValue = CustomSql.getCustomSql("NULL");

    public void addWhenThen(Model when, Model then) {
        AssertUtils.notNull(when, "when\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(then, "then\u4e0d\u80fd\u4e3a\u7a7a");
        this.whenValue.add(when);
        this.thenValue.add(then);
    }

    public void addElse(Model elseValue) {
        AssertUtils.notNull(elseValue, "else\u4e0d\u80fd\u4e3a\u7a7a");
        this.elseValue = elseValue;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.CASE;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        StringBuilder sql = new StringBuilder();
        sql.append("(").append("CASE").append(" ");
        int size = this.whenValue.size();
        for (int i = 0; i < size; ++i) {
            sql.append("WHEN").append(" ");
            sql.append(this.whenValue.get(i).getDatabaseSql(databaseType)).append(" ");
            sql.append("THEN").append(" ");
            sql.append(this.thenValue.get(i).getDatabaseSql(databaseType)).append(" ");
        }
        sql.append("ELSE").append(" ");
        sql.append(this.elseValue.getDatabaseSql(databaseType)).append(" ");
        sql.append("END").append(")");
        return sql.toString();
    }

    public List<Model> getWhenValue() {
        return this.whenValue;
    }

    public List<Model> getThenValue() {
        return this.thenValue;
    }

    public Model getElseValue() {
        return this.elseValue;
    }
}

