/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;
import com.sensesai.sql.util.KeywordUtils;
import com.sensesai.sql.util.Utils;

public final class Column
implements Model {
    private final String alias;
    private final Model model;

    private Column(String alias, Model model) {
        this.alias = alias;
        this.model = model;
    }

    public static Column getColumn(String alias, Model model) {
        AssertUtils.notNull(model, "\u67e5\u8be2\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        return new Column(alias, model);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.COLUMN;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        String sql = this.model.getDatabaseSql(databaseType);
        if (Utils.isNotEmpty(this.alias)) {
            sql = sql + " AS " + KeywordUtils.replaceKeyword(databaseType, this.alias);
        }
        return sql;
    }

    public String getAlias() {
        return this.alias;
    }

    public Model getModel() {
        return this.model;
    }
}

