/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.Cp;
import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.model.Condition;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;
import com.sensesai.sql.util.Utils;
import java.util.ArrayList;
import java.util.List;

public final class Conditions
implements Model {
    private Cp cp;
    private Condition condition;
    private List<Conditions> list;

    private Conditions(Cp cp, Condition condition, List<Conditions> list) {
        AssertUtils.notNull((Object)cp, "\u6761\u4ef6\u7ec4\u5408\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        this.cp = cp;
        this.condition = condition;
        this.list = list;
    }

    public static Conditions getInstance() {
        return new Conditions(Cp.NONE, null, new ArrayList<Conditions>());
    }

    public static Conditions getInstance(Cp cp) {
        AssertUtils.notEmpty((Object)cp, "\u7ec4\u5408\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        return new Conditions(cp, null, new ArrayList<Conditions>());
    }

    public static Conditions getInstance(Cp cp, Condition condition) {
        AssertUtils.notEmpty((Object)cp, "\u7ec4\u5408\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(condition, "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return new Conditions(cp, condition, null);
    }

    public static Conditions getInstance(Cp cp, Conditions ... arrays) {
        AssertUtils.notEmpty((Object)cp, "\u7ec4\u5408\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(arrays, "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<Conditions> list = new ArrayList<Conditions>();
        for (Conditions data : arrays) {
            list.add(data);
        }
        return new Conditions(cp, null, list);
    }

    public Conditions and(Condition condition) {
        this.list.add(new Conditions(Cp.AND, condition, null));
        return this;
    }

    public Conditions or(Condition condition) {
        this.list.add(new Conditions(Cp.AND, condition, null));
        return this;
    }

    public Conditions add(Conditions ... array) {
        for (Conditions conditions : array) {
            this.list.add(conditions);
        }
        return this;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.CONDITION;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        return this.buildSql(databaseType, true, true, this);
    }

    private String buildSql(DatabaseType databaseType, boolean isOuter, boolean isFirst, Conditions conditions) {
        if (conditions.getCondition() != null && Utils.isNotEmpty(conditions.getList())) {
            throw new SQLBuildException("\u53ea\u80fd\u662f\u5355\u4e2a\u6216\u591a\u4e2a\u6761\u4ef6\u4e2d\u7684\u4e00\u79cd");
        }
        StringBuilder sql = new StringBuilder();
        if (!isFirst) {
            if (conditions.getCp() != Cp.AND && conditions.getCp() != Cp.OR) {
                throw new SQLBuildException("\u7ec4\u5408\u65b9\u5f0f\u5fc5\u987b\u662fand\u6216or");
            }
            sql.append(" " + conditions.getCp().getCode() + " ");
        }
        if (conditions.getCondition() != null) {
            sql.append(conditions.getCondition().getDatabaseSql(databaseType));
        }
        if (Utils.isNotEmpty(conditions.getList())) {
            int size = conditions.getList().size();
            boolean flag = true;
            if (!isOuter) {
                sql.append("(");
            }
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    flag = false;
                }
                sql.append(this.buildSql(databaseType, false, flag, conditions.getList().get(i)));
            }
            if (!isOuter) {
                sql.append(")");
            }
        }
        return sql.toString();
    }

    public Cp getCp() {
        return this.cp;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public List<Conditions> getList() {
        return this.list;
    }
}

