/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DataType;
import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.ConstantUtils;

public final class Constant
implements Model {
    private final DataType type;
    private final String value;
    private final String format;
    private Integer length;
    private Integer precision;

    private Constant(DataType type, String value, String format, Integer length, Integer precision) {
        this.type = type;
        this.value = value;
        this.format = format;
        this.length = length;
        this.precision = precision;
    }

    public static Constant getConstant(DataType type, String value, String format, Integer length, Integer precision) {
        return new Constant(type, value, format, length, precision);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.CONSTANT;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        return ConstantUtils.putThreadLocalConstant(this);
    }

    public String getOriginalSql(DatabaseType databaseType) {
        return this.value;
    }

    public DataType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getFormat() {
        return this.format;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }
}

