/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.model.Table;
import com.sensesai.sql.util.AssertUtils;
import com.sensesai.sql.util.KeywordUtils;
import com.sensesai.sql.util.Utils;

public final class Field
implements Model {
    private final Table table;
    private final String filedName;

    private Field(Table table, String filedName) {
        AssertUtils.notEmpty(filedName, "\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        this.table = table;
        this.filedName = filedName;
    }

    public static Field getField(Table table, String filedName) {
        return new Field(table, filedName);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.FIELD;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        String sql = KeywordUtils.replaceKeyword(databaseType, this.filedName);
        if (this.table != null && Utils.isNotEmpty(this.table.getAlias())) {
            sql = this.table.getAlias() + "." + sql;
        }
        return sql;
    }

    public Table getTable() {
        return this.table;
    }

    public String getFiledName() {
        return this.filedName;
    }
}

