/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Model;
import java.util.ArrayList;
import java.util.List;

public final class Function
extends AbstractFunction {
    private final FunctionType functionType;
    private final List<Model> paramList = new ArrayList<Model>();

    private Function(FunctionType functionType) {
        this.functionType = functionType;
    }

    public static Function getFunction(FunctionType functionType, Model ... models) {
        if (functionType == FunctionType.RANK || functionType == FunctionType.DENSE_RANK || functionType == FunctionType.ROW_NUMBER) {
            throw new SQLBuildException("\u8bf7\u4f7f\u7528\u6392\u540d\u51fd\u6570\u7684\u83b7\u53d6\u65b9\u6cd5");
        }
        Function function = new Function(functionType);
        for (Model model : models) {
            function.getParamList().add(model);
        }
        return function;
    }

    @Override
    public FunctionType getType() {
        return this.functionType;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public List<Model> getParamList() {
        return this.paramList;
    }
}

