/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.Op;
import com.sensesai.sql.model.Condition;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;
import java.util.ArrayList;
import java.util.List;

public final class InCondition
extends Condition {
    private final Op op;
    private final Model left;
    private final List<Model> rightList;

    private InCondition(Op op, Model left, Model ... rights) {
        AssertUtils.notEmpty(left, op.getCode() + "\u5de6\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        this.op = op;
        this.left = left;
        ArrayList<Model> rightList = new ArrayList<Model>();
        for (Model right : rights) {
            AssertUtils.notEmpty(right, op.getCode() + "\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            rightList.add(right);
        }
        this.rightList = rightList;
    }

    public static InCondition in(Model left, Model ... rights) {
        return new InCondition(Op.IN, left, rights);
    }

    public static InCondition notIn(Model left, Model ... rights) {
        return new InCondition(Op.NOT_IN, left, rights);
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.left.getDatabaseSql(databaseType)).append(" ");
        sql.append(this.op.getCode()).append(" (");
        int size = this.rightList.size();
        for (int i = 0; i < size; ++i) {
            sql.append(this.rightList.get(i).getDatabaseSql(databaseType));
            if (i == size - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }

    public Op getOp() {
        return this.op;
    }

    public Model getLeft() {
        return this.left;
    }

    public List<Model> getRightList() {
        return this.rightList;
    }
}

