/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.JoinType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.Conditions;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.model.Query;
import com.sensesai.sql.util.AssertUtils;

public final class Join
implements Model {
    private final JoinType joinType;
    private final Model joinTable;
    private final Conditions joinConditions;

    private Join(JoinType joinType, Model joinTable, Conditions joinConditions) {
        AssertUtils.notNull((Object)joinType, "\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(joinTable, "\u5173\u8054\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(joinConditions, "\u5173\u8054\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.joinType = joinType;
        this.joinTable = joinTable;
        this.joinConditions = joinConditions;
    }

    public static Join getJoin(JoinType joinType, Model joinTable, Conditions joinConditions) {
        return new Join(joinType, joinTable, joinConditions);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.JOIN;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.joinType.getCode()).append(" ");
        ModelType modelType = this.joinTable.getModelType();
        switch (modelType) {
            case TABLE: {
                sql.append(this.joinTable.getDatabaseSql(databaseType));
                break;
            }
            case QUERY: {
                Query query = (Query)this.joinTable;
                sql.append(query.getChildQuerySql(databaseType));
                break;
            }
            default: {
                throw new RuntimeException("join\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6a21\u578b");
            }
        }
        sql.append(" ").append("ON").append(" ");
        sql.append(this.joinConditions.getDatabaseSql(databaseType));
        return sql.toString();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Model getJoinTable() {
        return this.joinTable;
    }

    public Conditions getJoinConditions() {
        return this.joinConditions;
    }
}

