/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.Model;
import java.util.Objects;

public final class MultipleModel
implements Model {
    private final Model[] models;

    private MultipleModel(Model[] models) {
        this.models = models;
    }

    public static MultipleModel getMultipleModel(Model ... models) {
        return new MultipleModel(models);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.MULTIPLE_MODEL;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        if (Objects.isNull(this.models)) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        for (Model model : this.models) {
            sql.append(model.getDatabaseSql(databaseType)).append(" ");
        }
        return sql.toString();
    }

    public Model[] getModels() {
        return this.models;
    }
}

