/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.enums.SortType;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.AssertUtils;

public final class Order
implements Model {
    private final SortType sortType;
    private final Model sortModel;

    private Order(SortType sortType, Model sortModel) {
        AssertUtils.notNull((Object)sortType, "\u6392\u5e8f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(sortModel, "\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        this.sortType = sortType;
        this.sortModel = sortModel;
    }

    public static Order getOrder(SortType sortType, Model sortModel) {
        return new Order(sortType, sortModel);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.ORDER;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        return this.sortModel.getDatabaseSql(databaseType) + " " + this.sortType.getCode();
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public Model getSortModel() {
        return this.sortModel;
    }
}

