/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.enums.SortType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.model.Column;
import com.sensesai.sql.model.Conditions;
import com.sensesai.sql.model.Join;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.model.Order;
import com.sensesai.sql.model.Table;
import com.sensesai.sql.util.AliasUtils;
import com.sensesai.sql.util.AssertUtils;
import com.sensesai.sql.util.ConstantUtils;
import com.sensesai.sql.util.Utils;
import com.sensesai.sql.vo.PrecompileParameterVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Query
implements Model {
    private String alias = "";
    private List<PrecompileParameterVo> precompileParameterVoList = new ArrayList<PrecompileParameterVo>();
    private Boolean isDistinct = false;
    private List<Model> select = new ArrayList<Model>();
    private List<Model> from = new ArrayList<Model>();
    private List<Join> join = new ArrayList<Join>();
    private Conditions where;
    private List<Model> group = new ArrayList<Model>();
    private Conditions having;
    private List<Order> order = new ArrayList<Order>();

    public Query addColumn(String alias, Model model) {
        AssertUtils.notNull(model, "\u67e5\u8be2\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        if (Utils.isNotEmpty(alias)) {
            Column column = Column.getColumn(alias, model);
            this.select.add(column);
        } else {
            this.select.add(model);
        }
        return this;
    }

    public Query addColumn(Model ... models) {
        AssertUtils.notEmpty(models, "\u67e5\u8be2\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        for (Model model : models) {
            this.select.add(model);
        }
        return this;
    }

    public Query addFrom(Table table) {
        this.from.add(table);
        return this;
    }

    public Query addFrom(Query query) {
        AssertUtils.notEmpty(query.getAlias(), "\u5b50\u67e5\u8be2\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        this.from.add(query);
        return this;
    }

    public Query addJoin(Join ... joins) {
        AssertUtils.notEmpty(joins, "join\u4e0d\u80fd\u4e3a\u7a7a");
        for (Join join : joins) {
            this.join.add(join);
        }
        return this;
    }

    public Query setWHere(Conditions where) {
        AssertUtils.notNull(where, "where\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.where = where;
        return this;
    }

    public Query addGroupBy(Model model) {
        this.group.add(model);
        return this;
    }

    public Query setHaving(Conditions having) {
        AssertUtils.notNull(having, "having\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.having = having;
        return this;
    }

    public Query addOrderBy(SortType sortType, Model sortModel) {
        Order orderModel = Order.getOrder(sortType, sortModel);
        this.order.add(orderModel);
        return this;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.QUERY;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        return this.buildSql(databaseType);
    }

    public String getChildQuerySql(DatabaseType databaseType) {
        if (this.alias == null || "".equals(this.alias.trim())) {
            throw new SQLBuildException("\u5b50\u67e5\u8be2\u5fc5\u987b\u6709\u522b\u540d");
        }
        return "(" + this.getDatabaseSql(databaseType) + ") " + this.alias;
    }

    public String getExecuteSql(DatabaseType databaseType) {
        String sql = this.buildSql(databaseType);
        return this.replaceConstant(databaseType, true, sql);
    }

    public String getPreSql(DatabaseType databaseType) {
        String sql = this.buildSql(databaseType);
        return this.replaceConstant(databaseType, false, sql);
    }

    private String buildSql(DatabaseType databaseType) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.buildSelectSql(databaseType)).append(" ");
        sql.append(this.toDatabaseSql(databaseType, "FROM", this.from)).append(" ");
        sql.append(this.toDatabaseSql(databaseType, this.join));
        sql.append(this.toDatabaseSql(databaseType, "WHERE", this.where)).append(" ");
        sql.append(this.toDatabaseSql(databaseType, "GROUP BY", this.group)).append(" ");
        sql.append(this.toDatabaseSql(databaseType, "HAVING", this.having)).append(" ");
        sql.append(this.toDatabaseSql(databaseType, "ORDER BY", this.order)).append(" ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceConstant(DatabaseType databaseType, boolean useValue, String sql) {
        try {
            String s = sql;
            for (Map.Entry<String, PrecompileParameterVo> entry : ConstantUtils.getThreadLocalConstant().entrySet()) {
                if (useValue) {
                    s = s.replace(entry.getKey(), ConstantUtils.convertDatabaseValue(databaseType, entry.getValue()));
                    continue;
                }
                s = s.replace(entry.getKey(), "?");
                this.precompileParameterVoList.add(entry.getValue());
            }
            String string = s;
            return string;
        }
        finally {
            AliasUtils.clean();
            ConstantUtils.cleanThreadLocalConstant();
        }
    }

    private String buildSelectSql(DatabaseType databaseType) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT").append(" ");
        if (this.isDistinct.booleanValue()) {
            sql.append("DISTINCT").append(" ");
        }
        if (this.select.isEmpty()) {
            sql.append("*");
        } else {
            this.appendList(databaseType, sql, this.select);
        }
        return sql.toString();
    }

    private String toDatabaseSql(DatabaseType databaseType, String keyword, List list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sql = new StringBuilder(keyword + " ");
        this.appendList(databaseType, sql, list);
        return sql.toString();
    }

    private String toDatabaseSql(DatabaseType databaseType, String keyword, Conditions conditions) {
        if (conditions == null) {
            return "";
        }
        return keyword + " " + conditions.getDatabaseSql(databaseType);
    }

    private String toDatabaseSql(DatabaseType databaseType, List<Join> joinList) {
        if (joinList.isEmpty()) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        for (Join join : joinList) {
            sql.append(join.getDatabaseSql(databaseType)).append(" ");
        }
        return sql.toString();
    }

    private void appendList(DatabaseType databaseType, StringBuilder sql, List list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Model model = (Model)list.get(i);
            if (model instanceof Query) {
                sql.append(((Query)model).getChildQuerySql(databaseType));
            } else {
                sql.append(((Model)list.get(i)).getDatabaseSql(databaseType));
            }
            if (i == size - 1) continue;
            sql.append(",");
        }
    }

    private void checkModel(Model model, ModelType ... types) {
        if (types != null && types.length > 0) {
            ModelType modelType = model.getModelType();
            boolean pass = false;
            for (ModelType type : types) {
                if (type != modelType) continue;
                pass = true;
                break;
            }
            if (!pass) {
                throw new SQLBuildException("\u6682\u4e0d\u652f\u6301" + (Object)((Object)modelType) + "\u6a21\u578b\u7c7b\u578b");
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public List<PrecompileParameterVo> getPrecompileParameterVoList() {
        return this.precompileParameterVoList;
    }

    public Boolean getIsDistinct() {
        return this.isDistinct;
    }

    public List<Model> getSelect() {
        return this.select;
    }

    public List<Model> getFrom() {
        return this.from;
    }

    public List<Join> getJoin() {
        return this.join;
    }

    public Conditions getWhere() {
        return this.where;
    }

    public List<Model> getGroup() {
        return this.group;
    }

    public Conditions getHaving() {
        return this.having;
    }

    public List<Order> getOrder() {
        return this.order;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPrecompileParameterVoList(List<PrecompileParameterVo> precompileParameterVoList) {
        this.precompileParameterVoList = precompileParameterVoList;
    }

    public void setIsDistinct(Boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public void setSelect(List<Model> select) {
        this.select = select;
    }

    public void setFrom(List<Model> from) {
        this.from = from;
    }

    public void setJoin(List<Join> join) {
        this.join = join;
    }

    public void setGroup(List<Model> group) {
        this.group = group;
    }

    public void setOrder(List<Order> order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        List<PrecompileParameterVo> this$precompileParameterVoList = this.getPrecompileParameterVoList();
        List<PrecompileParameterVo> other$precompileParameterVoList = other.getPrecompileParameterVoList();
        if (this$precompileParameterVoList == null ? other$precompileParameterVoList != null : !((Object)this$precompileParameterVoList).equals(other$precompileParameterVoList)) {
            return false;
        }
        Boolean this$isDistinct = this.getIsDistinct();
        Boolean other$isDistinct = other.getIsDistinct();
        if (this$isDistinct == null ? other$isDistinct != null : !((Object)this$isDistinct).equals(other$isDistinct)) {
            return false;
        }
        List<Model> this$select = this.getSelect();
        List<Model> other$select = other.getSelect();
        if (this$select == null ? other$select != null : !((Object)this$select).equals(other$select)) {
            return false;
        }
        List<Model> this$from = this.getFrom();
        List<Model> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        List<Join> this$join = this.getJoin();
        List<Join> other$join = other.getJoin();
        if (this$join == null ? other$join != null : !((Object)this$join).equals(other$join)) {
            return false;
        }
        Conditions this$where = this.getWhere();
        Conditions other$where = other.getWhere();
        if (this$where == null ? other$where != null : !this$where.equals(other$where)) {
            return false;
        }
        List<Model> this$group = this.getGroup();
        List<Model> other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        Conditions this$having = this.getHaving();
        Conditions other$having = other.getHaving();
        if (this$having == null ? other$having != null : !this$having.equals(other$having)) {
            return false;
        }
        List<Order> this$order = this.getOrder();
        List<Order> other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !((Object)this$order).equals(other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        List<PrecompileParameterVo> $precompileParameterVoList = this.getPrecompileParameterVoList();
        result = result * 59 + ($precompileParameterVoList == null ? 43 : ((Object)$precompileParameterVoList).hashCode());
        Boolean $isDistinct = this.getIsDistinct();
        result = result * 59 + ($isDistinct == null ? 43 : ((Object)$isDistinct).hashCode());
        List<Model> $select = this.getSelect();
        result = result * 59 + ($select == null ? 43 : ((Object)$select).hashCode());
        List<Model> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        List<Join> $join = this.getJoin();
        result = result * 59 + ($join == null ? 43 : ((Object)$join).hashCode());
        Conditions $where = this.getWhere();
        result = result * 59 + ($where == null ? 43 : $where.hashCode());
        List<Model> $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        Conditions $having = this.getHaving();
        result = result * 59 + ($having == null ? 43 : $having.hashCode());
        List<Order> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        return result;
    }

    public String toString() {
        return "Query(alias=" + this.getAlias() + ", precompileParameterVoList=" + this.getPrecompileParameterVoList() + ", isDistinct=" + this.getIsDistinct() + ", select=" + this.getSelect() + ", from=" + this.getFrom() + ", join=" + this.getJoin() + ", where=" + this.getWhere() + ", group=" + this.getGroup() + ", having=" + this.getHaving() + ", order=" + this.getOrder() + ")";
    }
}

