/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Model;
import java.util.ArrayList;
import java.util.List;

public final class RankFunction
extends AbstractFunction {
    private FunctionType functionType;
    private List<Model> orderList = new ArrayList<Model>();
    private List<Model> partitionList = new ArrayList<Model>();

    private RankFunction(FunctionType functionType, List<Model> partitionList, List<Model> orderList) {
        this.functionType = functionType;
        if (partitionList != null && partitionList.size() > 0) {
            this.partitionList.addAll(partitionList);
        }
        if (orderList != null && orderList.size() > 0) {
            this.orderList.addAll(orderList);
        }
    }

    public static RankFunction rank(List<Model> partitionByParamList, List<Model> orderByParamList) {
        return new RankFunction(FunctionType.RANK, partitionByParamList, orderByParamList);
    }

    public static RankFunction denseRank(List<Model> partitionByParamList, List<Model> orderByParamList) {
        return new RankFunction(FunctionType.DENSE_RANK, partitionByParamList, orderByParamList);
    }

    public static RankFunction rowNumber(List<Model> partitionByParamList, List<Model> orderByParamList) {
        return new RankFunction(FunctionType.ROW_NUMBER, partitionByParamList, orderByParamList);
    }

    @Override
    public FunctionType getType() {
        return this.functionType;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public List<Model> getOrderList() {
        return this.orderList;
    }

    public List<Model> getPartitionList() {
        return this.partitionList;
    }
}

