/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.model;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.ModelType;
import com.sensesai.sql.model.Field;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.model.Schema;
import com.sensesai.sql.util.KeywordUtils;
import com.sensesai.sql.util.Utils;
import java.util.ArrayList;
import java.util.List;

public final class Table
implements Model {
    private final Schema schema;
    private final String tableName;
    private final List<Field> fields = new ArrayList<Field>();
    private final String alias;
    private boolean isOriginal = true;
    private String childSql;

    private Table(Schema schema, String tableName, String alias) {
        this.schema = schema;
        this.tableName = tableName;
        this.alias = alias;
    }

    public static Table getOriginalTable(Schema schema, String tableName, String alias) {
        return new Table(schema, tableName, alias);
    }

    public static Table getCustomTable(Schema schema, String alias, String childSql) {
        Table table = new Table(schema, alias, alias);
        table.isOriginal = false;
        table.childSql = childSql;
        return table;
    }

    public Field addField(String fieldName) {
        Field field = Field.getField(this, fieldName);
        this.fields.add(field);
        return field;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.TABLE;
    }

    @Override
    public String getDatabaseSql(DatabaseType databaseType) {
        String tableSql = this.isOriginal ? (this.schema == null || Utils.isEmpty(this.schema.getSchemaName()) ? KeywordUtils.replaceKeyword(databaseType, this.tableName) : this.schema.getDatabaseSql(databaseType) + "." + KeywordUtils.replaceKeyword(databaseType, this.tableName)) : (this.childSql.trim().startsWith("(") ? this.childSql : "(" + this.childSql + ")");
        if (this.alias != null && !"".equals(this.alias.trim())) {
            tableSql = tableSql + " " + this.alias;
        }
        return tableSql;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public String getChildSql() {
        return this.childSql;
    }
}

