/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.parser;

import com.google.common.collect.ImmutableList;
import com.sensesai.sql.dto.SqlField;
import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.FunctionCheckDefinition;
import com.sensesai.sql.model.BinaryCondition;
import com.sensesai.sql.model.Case;
import com.sensesai.sql.model.CustomSql;
import com.sensesai.sql.model.Field;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.model.InCondition;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.model.MultipleModel;
import com.sensesai.sql.model.Table;
import com.sensesai.sql.util.AssertUtils;
import com.sensesai.sql.util.EnumUtils;
import com.sensesai.sql.util.FunCheckUtils;
import com.sensesai.sql.util.RegexUtils;
import com.sensesai.sql.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.util.NlsString;

public class ExpressionParser {
    private static final Set<String> SYMBOL = new HashSet<String>(Arrays.asList("=", "<>", ">", "<", ">=", "<=", "like", "not like", "is null", "is not null", "in", "not in"));
    private static final SqlParser.Config CONFIG = SqlParser.configBuilder().setLex(Lex.MYSQL).build();
    private Boolean isCheck = false;
    private Boolean isCountField = false;
    private Map<String, Table> tableMap = new HashMap<String, Table>();
    private Map<String, String> fieldTypeMap = new HashMap<String, String>();
    private List<SqlField> sqlFields = new ArrayList<SqlField>();

    public ExpressionParser setIsCheck(Boolean isCheck) {
        this.isCheck = isCheck;
        return this;
    }

    public ExpressionParser setIsCountField(Boolean isCountField) {
        this.isCountField = isCountField;
        return this;
    }

    public ExpressionParser setTableMap(Map<String, Table> tableMap) {
        if (tableMap != null && !tableMap.isEmpty()) {
            this.tableMap.putAll(tableMap);
        }
        return this;
    }

    public ExpressionParser setFieldTypeInfo(List<SqlField> fieldList) {
        for (SqlField sqlField : fieldList) {
            this.fieldTypeMap.put(this.getKey(sqlField.getTableAlias(), sqlField.getFieldName()), sqlField.getFieldType());
        }
        return this;
    }

    public List<SqlField> getSqlFields() {
        return this.sqlFields;
    }

    public Model parseExpression(String expression) throws SqlParseException {
        AssertUtils.notEmpty(expression, "\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        if (expression.toLowerCase().indexOf(" as ") > 0) {
            throw new SQLBuildException("\u51fd\u6570\u8868\u8fbe\u5f0f\u4e2d\u4e0d\u80fd\u5305\u542bas");
        }
        String sql = "select " + expression + " from dual";
        SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)CONFIG);
        SqlNode sqlNode = parser.parseQuery();
        SqlSelect sqlSelect = (SqlSelect)sqlNode;
        SqlNodeList selectList = sqlSelect.getSelectList();
        if (selectList.size() > 1) {
            throw new SQLBuildException("\u6682\u4e0d\u652f\u6301\u591a\u4e2a\u8868\u8fbe\u5f0f\uff1a" + expression);
        }
        return this.parse(selectList.get(0));
    }

    private Model parse(SqlNode sqlNode) {
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            SqlOperator sqlOperator = sqlBasicCall.getOperator();
            String operatorName = sqlOperator.getName();
            SqlNode[] operands = sqlBasicCall.getOperands();
            if (("and".equalsIgnoreCase(operatorName) || "or".equalsIgnoreCase(operatorName) || this.isComparisonSymbol(operatorName)) && sqlNode.toString().toLowerCase().indexOf("case") < 0) {
                return this.convertComparisonSymbolToCase(operatorName, operands);
            }
        }
        return this.parseSqlNode(sqlNode);
    }

    private Model parseSqlNode(SqlNode sqlNode) {
        if (sqlNode instanceof SqlIdentifier) {
            return this.parseSqlIdentifier((SqlIdentifier)sqlNode);
        }
        if (sqlNode instanceof SqlBasicCall) {
            return this.parseSqlBasicCall((SqlBasicCall)sqlNode);
        }
        if (sqlNode instanceof SqlCase) {
            return this.parseSqlCase((SqlCase)sqlNode);
        }
        if (sqlNode instanceof SqlLiteral) {
            return this.parseSqlLiteral((SqlLiteral)sqlNode);
        }
        throw new SQLBuildException("\u6682\u4e0d\u652f\u6301\u8be5\u8868\u8fbe\u5f0f\uff1a" + sqlNode.toString());
    }

    private Model parseSqlIdentifier(SqlIdentifier sqlIdentifier) {
        Table table;
        ImmutableList names = sqlIdentifier.names;
        String tableAlias = "";
        String fieldName = "";
        int size = names.size();
        if (size == 2) {
            tableAlias = (String)names.get(0);
            fieldName = (String)names.get(1);
        } else {
            fieldName = (String)names.get(0);
        }
        String key = this.getKey(tableAlias, fieldName);
        if (this.isCheck.booleanValue() && !this.fieldTypeMap.containsKey(key)) {
            throw new SQLBuildException("\u5b57\u6bb5" + key + "\u4e0d\u5b58\u5728");
        }
        if (this.isCountField.booleanValue()) {
            this.sqlFields.add(new SqlField(tableAlias, fieldName));
        }
        if ((table = this.getTableByAlias(tableAlias)) == null) {
            throw new SQLBuildException("\u5b57\u6bb5" + fieldName + "\u672a\u5173\u8054\u8868");
        }
        return Field.getField(table, fieldName);
    }

    private Model parseSqlBasicCall(SqlBasicCall sqlBasicCall) {
        SqlLiteral functionQuantifier;
        Model[] models;
        int len;
        FunctionType functionType;
        SqlOperator sqlOperator = sqlBasicCall.getOperator();
        String operatorName = sqlOperator.getName();
        SqlNode[] operands = sqlBasicCall.getOperands();
        if ("and".equalsIgnoreCase(operatorName) || "or".equalsIgnoreCase(operatorName) || this.isComparisonSymbol(operatorName)) {
            return this.convertComparisonSymbolToCondition(operatorName, operands);
        }
        if (this.isCheck.booleanValue()) {
            this.checkFunctionParam(operatorName, operands);
        }
        if ("trim".equalsIgnoreCase((functionType = EnumUtils.getFunctionTypeByCode(operatorName)).getCode())) {
            Model[] models2 = new Model[]{this.parseSqlNode(operands[2])};
            return Function.getFunction(functionType, models2);
        }
        if (Objects.nonNull(operands) && (len = operands.length) > 0) {
            models = new Model[len];
            for (int i = 0; i < len; ++i) {
                models[i] = this.parseSqlNode(operands[i]);
            }
        } else {
            models = new Model[]{};
        }
        if ("count".equalsIgnoreCase(operatorName) && (functionQuantifier = sqlBasicCall.getFunctionQuantifier()) != null && "distinct".equalsIgnoreCase(functionQuantifier.getValue().toString())) {
            return Function.getFunction(FunctionType.COUNT_DISTINCT, models[0]);
        }
        return Function.getFunction(functionType, models);
    }

    private Model parseSqlCase(SqlCase sqlCase) {
        SqlNodeList whenList = sqlCase.getWhenOperands();
        SqlNodeList thenList = sqlCase.getThenOperands();
        SqlNode elseNode = sqlCase.getElseOperand();
        if (Objects.isNull(whenList) || Objects.isNull(thenList) || whenList.size() != thenList.size()) {
            throw new SQLBuildException(sqlCase + "\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        Case caseModel = new Case();
        int size = whenList.size();
        for (int i = 0; i < size; ++i) {
            caseModel.addWhenThen(this.parseSqlNode(whenList.get(i)), this.parseSqlNode(thenList.get(i)));
        }
        caseModel.addElse(this.parseSqlNode(elseNode));
        return caseModel;
    }

    private Model convertComparisonSymbolToCondition(String operatorName, SqlNode[] operands) {
        if ("and".equalsIgnoreCase(operatorName) || "or".equalsIgnoreCase(operatorName)) {
            Model left = this.parseSqlNode(operands[0]);
            Model right = this.parseSqlNode(operands[1]);
            return MultipleModel.getMultipleModel(CustomSql.getCustomSql("("), left, CustomSql.getCustomSql(operatorName), right, CustomSql.getCustomSql(")"));
        }
        int size = operands.length;
        if ("is null".equalsIgnoreCase(operatorName) || "is not null".equalsIgnoreCase(operatorName)) {
            if (size != 1) {
                throw new SQLBuildException("is null\u548cis not null\u524d\u9762\u53ea\u80fd\u6709\u4e00\u4e2a\u8868\u8fbe\u5f0f");
            }
            Model left = this.parseSqlNode(operands[0]);
            if ("is null".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.isNull(left);
            }
            return BinaryCondition.isNotNull(left);
        }
        if ("in".equalsIgnoreCase(operatorName) || "not in".equalsIgnoreCase(operatorName)) {
            Model left = this.parseSqlNode(operands[0]);
            SqlNodeList sqlNodeLists = (SqlNodeList)operands[1];
            int count = sqlNodeLists.size();
            Model[] models = new Model[count];
            for (int i = 0; i < count; ++i) {
                models[i] = this.parseSqlNode(sqlNodeLists.get(i));
            }
            if ("in".equalsIgnoreCase(operatorName)) {
                return InCondition.in(left, models);
            }
            return InCondition.notIn(left, models);
        }
        if (size == 2) {
            Model left = this.parseSqlNode(operands[0]);
            Model right = this.parseSqlNode(operands[1]);
            if ("=".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.equal(left, right);
            }
            if ("<>".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.notEqual(left, right);
            }
            if (">".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.greaterThan(left, right);
            }
            if ("<".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.lessThan(left, right);
            }
            if (">=".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.greaterThanOrEqual(left, right);
            }
            if ("<=".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.lessThanOrEqual(left, right);
            }
            if ("like".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.like(left, right);
            }
            if ("not like".equalsIgnoreCase(operatorName)) {
                return BinaryCondition.notLike(left, right);
            }
        }
        throw new SQLBuildException(operatorName + "\u6682\u4e0d\u652f\u6301");
    }

    private Model convertComparisonSymbolToCase(String operatorName, SqlNode[] operands) {
        Case caseModel = new Case();
        Model model = this.convertComparisonSymbolToCondition(operatorName, operands);
        caseModel.addWhenThen(model, CustomSql.getCustomSql("1"));
        caseModel.addElse(CustomSql.getCustomSql("0"));
        return caseModel;
    }

    private Model parseSqlLiteral(SqlLiteral sqlLiteral) {
        String value = this.getStringOfSqlLiteral(sqlLiteral);
        return CustomSql.getCustomSql(value);
    }

    private boolean isComparisonSymbol(String operatorName) {
        return SYMBOL.contains(operatorName.toLowerCase());
    }

    private Table getTableByAlias(String tableAlias) {
        Table table = this.tableMap.get(tableAlias);
        if (table == null) {
            table = this.tableMap.get("");
        }
        return table;
    }

    private void checkFunctionParam(String operatorName, SqlNode[] params) {
        int paramCount;
        FunctionCheckDefinition checkDefinition = FunCheckUtils.getCheckDefinitionByName(operatorName);
        if (Objects.isNull(checkDefinition)) {
            return;
        }
        int n = paramCount = Objects.isNull(params) ? 0 : params.length;
        if (paramCount < checkDefinition.getMin() || paramCount > checkDefinition.getMax()) {
            if (checkDefinition.getMin().intValue() == checkDefinition.getMax().intValue()) {
                throw new SQLBuildException("\u51fd\u6570" + operatorName + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u9700\u8981\uff1a" + checkDefinition.getMin() + "\uff0c\u5b9e\u9645\uff1a" + paramCount);
            }
            throw new SQLBuildException("\u51fd\u6570" + operatorName + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u6700\u5c11\uff1a" + checkDefinition.getMin() + "\uff0c\u6700\u591a" + checkDefinition.getMax() + "\uff0c\u5b9e\u9645\uff1a" + paramCount);
        }
        if (params != null && params.length > 0) {
            int index = 0;
            for (SqlNode sqlNode : params) {
                String[] array = FunCheckUtils.getDataType(operatorName, index, params.length);
                if (sqlNode instanceof SqlIdentifier) {
                    this.checkSqlIdentifier(array, (SqlIdentifier)sqlNode, "\u51fd\u6570" + operatorName + "\u7b2c" + (index + 1) + "\u4e2a\u53c2\u6570");
                } else if (sqlNode instanceof SqlLiteral) {
                    this.checkSqlLiteral(array, (SqlLiteral)sqlNode, "\u51fd\u6570" + operatorName);
                } else if (sqlNode instanceof SqlBasicCall) {
                    this.checkSqlBasicCall(array, (SqlBasicCall)sqlNode, "");
                }
                ++index;
            }
        }
    }

    private void checkSqlIdentifier(String[] checkRegexType, SqlIdentifier sqlIdentifier, String prefix) {
        String fieldName;
        ImmutableList names = sqlIdentifier.names;
        String tableAlias = "";
        int size = names.size();
        if (size == 2) {
            tableAlias = (String)names.get(0);
            fieldName = (String)names.get(1);
        } else {
            fieldName = (String)names.get(0);
        }
        String key = this.getKey(tableAlias, fieldName);
        if (!this.fieldTypeMap.containsKey(key)) {
            throw new SQLBuildException("\u5b57\u6bb5" + key + "\u4e0d\u5b58\u5728");
        }
        String fieldType = this.fieldTypeMap.get(key);
        boolean pass = false;
        for (String str : checkRegexType) {
            if ("all".equalsIgnoreCase(str)) {
                pass = true;
                break;
            }
            if (!str.equalsIgnoreCase(fieldType) && !"string_field".equalsIgnoreCase(fieldType)) continue;
            pass = true;
            break;
        }
        if (!pass) {
            throw new SQLBuildException(prefix + "\uff0c\u5fc5\u987b\u662f\uff1a" + this.convertDataTypeMsg(checkRegexType) + "\uff0c\u5b9e\u9645\u662f\uff1a" + fieldType);
        }
    }

    private void checkSqlLiteral(String[] checkRegexType, SqlLiteral sqlLiteral, String prefix) {
        String value = this.getStringOfSqlLiteral(sqlLiteral);
        if ("null".equalsIgnoreCase(value)) {
            return;
        }
        boolean pass = false;
        for (String str : checkRegexType) {
            if ("all".equalsIgnoreCase(str)) {
                pass = true;
                break;
            }
            if (("int".equalsIgnoreCase(str) || "integer".equalsIgnoreCase(str)) && RegexUtils.isMatchInt(value)) {
                pass = true;
                break;
            }
            if ("number".equalsIgnoreCase(str) && RegexUtils.isMatchNumber(value)) {
                pass = true;
                break;
            }
            if ("string".equalsIgnoreCase(str) && RegexUtils.isMatchVarchar(value)) {
                pass = true;
                break;
            }
            if ("date_format".equalsIgnoreCase(str) && RegexUtils.isMatchDateFormat(value)) {
                pass = true;
                break;
            }
            if ("datetime_varchar".equalsIgnoreCase(str) && RegexUtils.isMatchDateTimeVarchar(value)) {
                pass = true;
                break;
            }
            if ("date_varchar".equalsIgnoreCase(str) && RegexUtils.isMatchDateVarchar(value)) {
                pass = true;
                break;
            }
            if ("time_varchar".equalsIgnoreCase(str) && RegexUtils.isMatchTimeVarchar(value)) {
                pass = true;
                break;
            }
            if (!"time_unit".equalsIgnoreCase(str) || !RegexUtils.isMatchTimeUnit(value)) continue;
            pass = true;
            break;
        }
        if (!pass) {
            throw new SQLBuildException(prefix + "\u53c2\u6570\u503c" + value + "\u4e0d\u6b63\u786e\u5fc5\u987b\u662f\uff1a" + this.convertDataTypeMsg(checkRegexType));
        }
    }

    private void checkSqlBasicCall(String[] checkRegexType, SqlBasicCall sqlBasicCall, String prefix) {
        SqlOperator sqlOperator = sqlBasicCall.getOperator();
        String operatorName = sqlOperator.getName();
        FunctionCheckDefinition checkDefinition = FunCheckUtils.getCheckDefinitionByName(operatorName);
        if (checkDefinition != null) {
            boolean pass = false;
            for (String str : checkRegexType) {
                if (!str.equalsIgnoreCase(checkDefinition.getReturnType())) continue;
                pass = true;
            }
            if (!pass) {
                throw new SQLBuildException("\u8868\u8fbe\u5f0f" + sqlBasicCall + "\u8fd4\u56de\u503c\u7c7b\u578b" + checkDefinition.getReturnType() + "\u548c\u51fd\u6570\u53c2\u6570\u6240\u9700\u7c7b\u578b" + this.convertDataTypeMsg(checkRegexType) + "\u4e0d\u5339\u914d");
            }
        }
    }

    private String convertDataTypeMsg(String ... array) {
        StringBuilder sb = new StringBuilder();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            sb.append(this.getChinese(array[i]));
            if (i == len - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getChinese(String dateType) {
        String s;
        switch (s = dateType.toLowerCase()) {
            case "string_field": {
                return "\u6587\u672c\u7c7b\u578b\u5b57\u6bb5";
            }
            case "string": {
                return "\u6587\u672c\u7c7b\u578b";
            }
            case "int": 
            case "integer": {
                return "\u6574\u6570\u7c7b\u578b";
            }
            case "time": {
                return "\u65f6\u95f4\u7c7b\u578b";
            }
            case "date": {
                return "\u65e5\u671f\u7c7b\u578b";
            }
            case "datetime": {
                return "\u65e5\u671f\u65f6\u95f4\u7c7b\u578b";
            }
            case "date_format": {
                DateFormatType[] values = DateFormatType.values();
                int len = values.length;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < len; ++i) {
                    sb.append("'").append(values[i].getCode()).append("'");
                    if (i == len - 1) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            case "time_unit": {
                TimeUnitType[] values1 = TimeUnitType.values();
                int len1 = values1.length;
                StringBuilder sb1 = new StringBuilder();
                for (int i = 0; i < len1; ++i) {
                    sb1.append("'").append(values1[i].getCode()).append("'");
                    if (i == len1 - 1) continue;
                    sb1.append(",");
                }
                return sb1.toString();
            }
            case "datetime_varchar": {
                return "\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\uff08\u5982\uff1a'2021-01-01 08:00:00'\u3001'20210101080000'\uff09";
            }
            case "date_varchar": {
                return "\u65e5\u671f\u5b57\u7b26\u4e32\uff08\u5982\uff1a'2021-01-01'\u3001'20210101'\uff09";
            }
            case "time_varchar": {
                return "\u65f6\u95f4\u5b57\u7b26\u4e32\uff08\u5982\uff1a'08:00:00'\u3001'080000'\uff09";
            }
        }
        return dateType;
    }

    private String getKey(String tableAlias, String fieldName) {
        String key = Utils.isEmpty(tableAlias) ? fieldName : tableAlias + "." + fieldName;
        return key;
    }

    private String getStringOfSqlLiteral(SqlLiteral sqlLiteral) {
        Object value = sqlLiteral.getValue();
        if (Objects.isNull(value)) {
            return "null";
        }
        if (value instanceof NlsString) {
            return "'" + ((NlsString)value).getValue() + "'";
        }
        return value.toString();
    }
}

