/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.parser;

import com.google.common.collect.ImmutableList;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StellaSqlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StellaSqlParser.class);
    private SqlParser.Config config = SqlParser.configBuilder().setLex(Lex.MYSQL).build();
    private String oldTableName;
    private String newTableName;
    private List<ReplaceNode> replaceNodeList = new ArrayList<ReplaceNode>();

    public StellaSqlParser(String oldTableName, String newTableName) {
        this("", oldTableName, newTableName);
    }

    public StellaSqlParser(String quotingStr, String oldTableName, String newTableName) {
        if (Utils.isEmpty(oldTableName)) {
            throw new SQLBuildException("\u65e7\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Utils.isEmpty(newTableName)) {
            throw new SQLBuildException("\u65b0\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
        if (Quoting.DOUBLE_QUOTE.string.equals(quotingStr)) {
            this.config = SqlParser.configBuilder().setLex(Lex.ORACLE).build();
        } else if (Quoting.BRACKET.string.equals(quotingStr)) {
            this.config = SqlParser.configBuilder().setLex(Lex.SQL_SERVER).build();
        }
    }

    public String replace(String sql) {
        int i;
        String targetSql = this.unescapeSql(sql);
        this.parseSql(targetSql);
        this.sort();
        String[] split = targetSql.split("\n");
        int totalLine = split.length;
        int lastColumnNum = 0;
        int lastLineNum = 0;
        StringBuilder sb = new StringBuilder();
        int size = this.replaceNodeList.size();
        for (i = 0; i < size; ++i) {
            boolean needAppendAfter;
            SqlParserPos nexPosition;
            SqlIdentifier sqlIdentifier = this.replaceNodeList.get(i).getSqlIdentifier();
            int pos = this.replaceNodeList.get(i).getIndex();
            SqlParserPos position = sqlIdentifier.getComponentParserPosition(pos);
            int columnNum = position.getColumnNum();
            int lineNum = position.getLineNum();
            int endColumnNum = position.getEndColumnNum();
            int endLineNum = position.getEndLineNum();
            for (int j = lastLineNum; j < lineNum - 1; ++j) {
                sb.append(split[j]).append("\n");
            }
            if (lineNum != lastLineNum) {
                lastColumnNum = 0;
            }
            String lineStr = split[lineNum - 1];
            int endIndex = columnNum - 1;
            String beforeStr = lineStr.substring(lastColumnNum, endIndex);
            sb.append(beforeStr);
            String value = lineStr.substring(columnNum - 1, endColumnNum);
            sb.append(value.replace(this.oldTableName, this.newTableName));
            boolean hasNext = false;
            if (i + 1 < size && (nexPosition = this.replaceNodeList.get(i + 1).getSqlIdentifier().getComponentParserPosition(this.replaceNodeList.get(i + 1).getIndex())).getLineNum() == lineNum) {
                hasNext = true;
            }
            int len = lineStr.length();
            boolean bl = needAppendAfter = !hasNext && endColumnNum < len;
            if (needAppendAfter) {
                String afterStr = lineStr.substring(endColumnNum, len);
                sb.append(afterStr).append("\n");
            }
            lastColumnNum = endColumnNum;
            lastLineNum = endLineNum;
            if (sqlIdentifier.names.size() != 2 || sqlIdentifier.getComponentParserPosition(1 - pos).getLineNum() == lineNum || needAppendAfter) continue;
            sb.append("\n");
        }
        if (lastLineNum < totalLine) {
            for (i = lastLineNum; i < totalLine; ++i) {
                sb.append(split[i]).append("\n");
            }
        }
        return sb.toString();
    }

    private void sort() {
        this.replaceNodeList.stream().sorted((o1, o2) -> {
            SqlParserPos position1 = o1.getSqlIdentifier().getParserPosition();
            int lineNumber1 = position1.getLineNum();
            int columnNumber1 = position1.getColumnNum();
            SqlParserPos position2 = o2.getSqlIdentifier().getParserPosition();
            int lineNumber2 = position2.getLineNum();
            int columnNumber2 = position2.getColumnNum();
            if (lineNumber1 < lineNumber2 || lineNumber1 == lineNumber2 && columnNumber1 < columnNumber2) {
                return 1;
            }
            return -1;
        });
    }

    private String unescapeSql(String sql) {
        return sql.replace("!=", "<>");
    }

    private void parseSql(String sql) {
        SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)this.config);
        try {
            SqlNode sqlNode = parser.parseQuery();
            this.parseSqlNode(SqlSource.QUERY, sqlNode);
        }
        catch (Exception e) {
            LOGGER.error("sql\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new SQLBuildException("sql\u89e3\u6790\u5931\u8d25", e);
        }
    }

    private void parseSqlNode(SqlSource sqlSource, SqlNode sqlNode) {
        if (sqlNode instanceof SqlSelect) {
            this.parseSqlSelect((SqlSelect)sqlNode);
        } else if (sqlNode instanceof SqlOrderBy) {
            this.parseSqlOrderBy((SqlOrderBy)sqlNode);
        } else if (sqlNode instanceof SqlLiteral) {
            this.parseSqlLiteral((SqlLiteral)sqlNode);
        } else if (sqlNode instanceof SqlIdentifier) {
            this.parseSqlIdentifier(sqlSource, (SqlIdentifier)sqlNode);
        } else if (sqlNode instanceof SqlBasicCall) {
            this.parseSqlBasicCall(sqlSource, (SqlBasicCall)sqlNode);
        } else if (sqlNode instanceof SqlCase) {
            this.parseSqlCase(sqlSource, (SqlCase)sqlNode);
        } else if (sqlNode instanceof SqlJoin) {
            this.parseSqlJoin((SqlJoin)sqlNode);
        }
    }

    private void parseSqlOrderBy(SqlOrderBy sqlOrderBy) {
        SqlNode query = sqlOrderBy.query;
        this.parseSqlNode(SqlSource.QUERY, query);
        SqlNodeList orderList = sqlOrderBy.orderList;
        int size = orderList.size();
        for (int i = 0; i < size; ++i) {
            this.parseSqlNode(SqlSource.ORDER_BY, orderList.get(i));
        }
    }

    private void parseSqlSelect(SqlSelect sqlSelect) {
        SqlNodeList orderList;
        SqlNode having;
        SqlNodeList groupList;
        SqlNodeList selectList = sqlSelect.getSelectList();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            this.parseSqlNode(SqlSource.SELECT, selectList.get(i));
        }
        SqlNode from = sqlSelect.getFrom();
        this.parseSqlNode(SqlSource.FROM, from);
        SqlNode where = sqlSelect.getWhere();
        if (where != null) {
            this.parseSqlNode(SqlSource.WHERE, where);
        }
        if ((groupList = sqlSelect.getGroup()) != null && groupList.size() > 0) {
            int size2 = groupList.size();
            for (int i = 0; i < size2; ++i) {
                this.parseSqlNode(SqlSource.GROUP_BY, groupList.get(i));
            }
        }
        if ((having = sqlSelect.getHaving()) != null) {
            this.parseSqlNode(SqlSource.HAVING, having);
        }
        if ((orderList = sqlSelect.getOrderList()) != null && orderList.size() > 0) {
            int size3 = orderList.size();
            for (int i = 0; i < size3; ++i) {
                this.parseSqlNode(SqlSource.ORDER_BY, orderList.get(i));
            }
        }
    }

    private void parseSqlJoin(SqlJoin sqlJoin) {
        SqlNode left = sqlJoin.getLeft();
        SqlNode right = sqlJoin.getRight();
        SqlNode condition = sqlJoin.getCondition();
        this.parseSqlNode(SqlSource.JOIN, left);
        this.parseSqlNode(SqlSource.JOIN, right);
        this.parseSqlNode(SqlSource.JOIN_CONDITION, condition);
    }

    private void parseSqlLiteral(SqlLiteral sqlLiteral) {
        Object value = sqlLiteral.getValue();
    }

    private void parseSqlIdentifier(SqlSource sqlSource, SqlIdentifier sqlIdentifier) {
        ImmutableList names = sqlIdentifier.names;
        String alias = "";
        String name = "";
        int size = names.size();
        if (size == 2) {
            alias = (String)names.get(0);
            name = (String)names.get(1);
        } else {
            name = (String)names.get(0);
        }
        if (sqlSource == SqlSource.FROM || sqlSource == SqlSource.JOIN) {
            if (this.oldTableName.equals(name)) {
                if (size == 2) {
                    this.replaceNodeList.add(new ReplaceNode(1, sqlIdentifier));
                } else {
                    this.replaceNodeList.add(new ReplaceNode(0, sqlIdentifier));
                }
            }
        } else if (this.oldTableName.equals(alias)) {
            this.replaceNodeList.add(new ReplaceNode(0, sqlIdentifier));
        }
    }

    private void parseSqlCase(SqlSource sqlSource, SqlCase sqlCase) {
        SqlNodeList whenList = sqlCase.getWhenOperands();
        SqlNodeList thenList = sqlCase.getThenOperands();
        SqlNode elseNode = sqlCase.getElseOperand();
        int size = whenList.size();
        for (int i = 0; i < size; ++i) {
            this.parseSqlNode(sqlSource, whenList.get(i));
            this.parseSqlNode(sqlSource, thenList.get(i));
        }
        this.parseSqlNode(sqlSource, elseNode);
    }

    private void parseSqlBasicCall(SqlSource sqlSource, SqlBasicCall sqlBasicCall) {
        SqlOperator operator = sqlBasicCall.getOperator();
        SqlNode[] operands = sqlBasicCall.getOperands();
        SqlKind kind = operator.getKind();
        switch (kind) {
            case AS: {
                this.parseOperatorAs(sqlSource, operands);
                break;
            }
            default: {
                this.parseOperatorDefault(sqlSource, operands);
            }
        }
    }

    private void parseOperatorAs(SqlSource sqlSource, SqlNode[] operands) {
        int len = operands.length;
        for (int i = 0; i < len; ++i) {
            this.parseSqlNode(sqlSource, operands[i]);
        }
    }

    private void parseOperatorDefault(SqlSource sqlSource, SqlNode[] operands) {
        int len = operands.length;
        for (int i = 0; i < len; ++i) {
            this.parseSqlNode(sqlSource, operands[i]);
        }
    }

    public SqlParser.Config getConfig() {
        return this.config;
    }

    public String getOldTableName() {
        return this.oldTableName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public List<ReplaceNode> getReplaceNodeList() {
        return this.replaceNodeList;
    }

    public void setConfig(SqlParser.Config config) {
        this.config = config;
    }

    public void setOldTableName(String oldTableName) {
        this.oldTableName = oldTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public void setReplaceNodeList(List<ReplaceNode> replaceNodeList) {
        this.replaceNodeList = replaceNodeList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StellaSqlParser)) {
            return false;
        }
        StellaSqlParser other = (StellaSqlParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SqlParser.Config this$config = this.getConfig();
        SqlParser.Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        String this$oldTableName = this.getOldTableName();
        String other$oldTableName = other.getOldTableName();
        if (this$oldTableName == null ? other$oldTableName != null : !this$oldTableName.equals(other$oldTableName)) {
            return false;
        }
        String this$newTableName = this.getNewTableName();
        String other$newTableName = other.getNewTableName();
        if (this$newTableName == null ? other$newTableName != null : !this$newTableName.equals(other$newTableName)) {
            return false;
        }
        List<ReplaceNode> this$replaceNodeList = this.getReplaceNodeList();
        List<ReplaceNode> other$replaceNodeList = other.getReplaceNodeList();
        return !(this$replaceNodeList == null ? other$replaceNodeList != null : !((Object)this$replaceNodeList).equals(other$replaceNodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StellaSqlParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SqlParser.Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        String $oldTableName = this.getOldTableName();
        result = result * 59 + ($oldTableName == null ? 43 : $oldTableName.hashCode());
        String $newTableName = this.getNewTableName();
        result = result * 59 + ($newTableName == null ? 43 : $newTableName.hashCode());
        List<ReplaceNode> $replaceNodeList = this.getReplaceNodeList();
        result = result * 59 + ($replaceNodeList == null ? 43 : ((Object)$replaceNodeList).hashCode());
        return result;
    }

    public String toString() {
        return "StellaSqlParser(config=" + this.getConfig() + ", oldTableName=" + this.getOldTableName() + ", newTableName=" + this.getNewTableName() + ", replaceNodeList=" + this.getReplaceNodeList() + ")";
    }

    private static class ReplaceNode {
        private int index;
        private SqlIdentifier sqlIdentifier;

        ReplaceNode(int index, SqlIdentifier sqlIdentifier) {
            this.index = index;
            this.sqlIdentifier = sqlIdentifier;
        }

        public int getIndex() {
            return this.index;
        }

        public SqlIdentifier getSqlIdentifier() {
            return this.sqlIdentifier;
        }
    }

    private static enum SqlSource {
        QUERY,
        SELECT,
        FROM,
        JOIN,
        JOIN_CONDITION,
        WHERE,
        GROUP_BY,
        HAVING,
        ORDER_BY,
        OTHER;

    }
}

