/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.sensesai.sql.enums.DataType;
import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.model.Constant;
import com.sensesai.sql.model.CustomSql;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.vo.PrecompileParameterVo;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.time.DateUtils;

public class ConstantUtils {
    private static final ThreadLocal<LinkedHashMap<String, PrecompileParameterVo>> PARAMETER = ThreadLocal.withInitial(LinkedHashMap::new);
    private static final ThreadLocal<AtomicInteger> PARAMETER_NUM = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    public static String convertDatabaseValue(DatabaseType databaseType, DataType dataType, String value, String format, Integer length, Integer precision) {
        if (value == null) {
            return "null";
        }
        switch (dataType) {
            case STRING: {
                return "'" + value + "'";
            }
            case INT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case NUMBER: {
                return value;
            }
            case DATE: 
            case DATETIME: 
            case TIME: {
                return Function.getFunction(FunctionType.STRING_TO_DATE, CustomSql.getCustomSql("'" + value + "'"), CustomSql.getCustomSql(DateFormatType.YYYY_MM_DD_HH24_MI_SS.getCode())).getDatabaseSql(databaseType);
            }
        }
        throw new SQLBuildException("\u6682\u4e0d\u652f\u6301" + dataType.getCode() + "\u6570\u636e\u7c7b\u578b");
    }

    public static String convertDatabaseValue(DatabaseType databaseType, PrecompileParameterVo parameterVo) {
        DataType dataType = DataType.getEnumByCode(parameterVo.getDataType());
        if (dataType == null) {
            throw new SQLBuildException("\u6682\u4e0d\u652f\u6301" + dataType.getCode() + "\u6570\u636e\u7c7b\u578b");
        }
        return ConstantUtils.convertDatabaseValue(databaseType, dataType, parameterVo.getDataValue(), parameterVo.getDataFormat(), parameterVo.getDataLength(), parameterVo.getDataPrecision());
    }

    public static Object convertValue(DataType dataType, String value, String format, Integer length, Integer precision) {
        switch (dataType) {
            case STRING: {
                return value;
            }
            case INT: 
            case INTEGER: {
                return ConstantUtils.getInt(value);
            }
            case LONG: 
            case BIGINT: {
                return ConstantUtils.getLong(value);
            }
            case FLOAT: {
                return ConstantUtils.getFloat(value);
            }
            case DOUBLE: {
                return ConstantUtils.getDouble(value);
            }
            case NUMBER: {
                if (length != null && length <= 18 && precision != null && precision == 0) {
                    return ConstantUtils.getLong(value);
                }
                return ConstantUtils.getBigDecimal(value);
            }
            case DATE: 
            case DATETIME: {
                return ConstantUtils.getDate(value, format);
            }
            case TIME: {
                return ConstantUtils.getTime(value, format);
            }
        }
        throw new SQLBuildException("\u6682\u4e0d\u652f\u6301" + dataType.getCode() + "\u6570\u636e\u7c7b\u578b");
    }

    public static String putThreadLocalConstant(Constant model) {
        String key = ConstantUtils.getConstantReplace();
        PrecompileParameterVo parameter = new PrecompileParameterVo();
        parameter.setDataType(model.getType().getCode());
        parameter.setDataValue(model.getValue());
        parameter.setDataFormat(model.getFormat());
        parameter.setDataLength(model.getLength());
        parameter.setDataPrecision(model.getPrecision());
        parameter.setValue(ConstantUtils.convertValue(model.getType(), model.getValue(), model.getFormat(), model.getLength(), model.getPrecision()));
        PARAMETER.get().put(key, parameter);
        return key;
    }

    public static Map<String, PrecompileParameterVo> getThreadLocalConstant() {
        return PARAMETER.get();
    }

    public static void cleanThreadLocalConstant() {
        PARAMETER.remove();
        PARAMETER_NUM.remove();
    }

    private static String getConstantReplace() {
        return "#{" + ConstantUtils.getFixedValue(PARAMETER_NUM.get().getAndIncrement(), 3) + "}";
    }

    private static String getFixedValue(int value, int len) {
        String s = value + "";
        while (s.length() <= len) {
            s = "0" + s;
        }
        return s;
    }

    public static Short getShort(String value) {
        try {
            return Short.valueOf(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210short", e);
        }
    }

    public static Byte getByte(String value) {
        try {
            return Byte.valueOf(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Byte", e);
        }
    }

    public static Integer getInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Int", e);
        }
    }

    public static Long getLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Long", e);
        }
    }

    public static Float getFloat(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Float", e);
        }
    }

    public static Double getDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Double", e);
        }
    }

    public static BigDecimal getBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210BigDecimal", e);
        }
    }

    public static Date getDate(String value, String format) {
        try {
            if (format != null && !"".equals(format.trim())) {
                return new Date(DateUtils.parseDate((String)value, (String[])new String[]{format}).getTime());
            }
            return new Date(DateUtils.parseDate((String)value, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"}).getTime());
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Date", e);
        }
    }

    public static Time getTime(String value, String format) {
        try {
            if (format != null && !"".equals(format.trim())) {
                return new Time(DateUtils.parseDate((String)value, (String[])new String[]{format}).getTime());
            }
            return new Time(DateUtils.parseDate((String)value, (String[])new String[]{"HH:mm:ss", "yyyy-MM-dd HH:mm:ss"}).getTime());
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Time", e);
        }
    }

    public static Timestamp getTimestamp(String value, String format) {
        try {
            if (format != null && !"".equals(format.trim())) {
                return new Timestamp(DateUtils.parseDate((String)value, (String[])new String[]{format}).getTime());
            }
            return new Timestamp(DateUtils.parseDate((String)value, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"}).getTime());
        }
        catch (Exception e) {
            throw new SQLBuildException(value + "\u4e0d\u80fd\u8f6c\u6362\u6210Timestamp", e);
        }
    }
}

