/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.sensesai.sql.enums.Cp;
import com.sensesai.sql.enums.DataType;
import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.enums.JoinType;
import com.sensesai.sql.enums.Op;
import com.sensesai.sql.exception.SQLBuildException;

public class EnumUtils {
    public static FunctionType getFunctionTypeByCode(String code) {
        FunctionType type = FunctionType.getEnumByCode(code);
        if (type == null) {
            throw new SQLBuildException("\u6682\u4e0d\u652f\u6301\u8be5\u51fd\u6570\uff1a" + code);
        }
        return type;
    }

    public static DatabaseType getDatabaseTypeByCode(String code) {
        DatabaseType type = DatabaseType.getEnumByCode(code.toLowerCase().trim());
        if (type == null) {
            throw new SQLBuildException("\u6682\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + code);
        }
        return type;
    }

    public static JoinType getJoinTypeByCode(String code) {
        JoinType type = JoinType.getEnumByCode(code);
        if (type == null) {
            throw new SQLBuildException("\u5173\u8054\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + code);
        }
        return type;
    }

    public static DataType getDataTypeByCode(String code) {
        DataType type = DataType.getEnumByCode(code);
        if (type == null) {
            throw new SQLBuildException("\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + code);
        }
        return type;
    }

    public static Op getOpByCode(String code) {
        if ("IN LIST".equalsIgnoreCase(code)) {
            return Op.IN;
        }
        if ("CONTAINS".equalsIgnoreCase(code) || "STARTS WITH".equalsIgnoreCase(code) || "ENDS WITH".equalsIgnoreCase(code)) {
            return Op.LIKE;
        }
        Op type = Op.getEnumByCode(code);
        if (type == null) {
            throw new SQLBuildException("\u6761\u4ef6\u5339\u914d\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + code);
        }
        return type;
    }

    public static Cp getCpByCode(String code) {
        if ("-".equals(code)) {
            return Cp.NONE;
        }
        Cp type = Cp.getEnumByCode(code);
        if (type == null) {
            throw new SQLBuildException("\u6761\u4ef6\u7ec4\u5408\u65b9\u5f0f\u4e0d\u6b63\u786e\uff1a" + code);
        }
        return type;
    }
}

