/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.sensesai.sql.dto.SqlField;
import com.sensesai.sql.enums.DataType;
import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.model.CustomSql;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.model.Table;
import com.sensesai.sql.parser.ExpressionParser;
import com.sensesai.sql.util.RegexUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionUtils.class);

    public static Model toModel(String expressStr, Map<String, Table> tableMap) {
        Model model;
        ExpressionParser parser = new ExpressionParser();
        parser.setTableMap(tableMap);
        try {
            model = parser.parseExpression(expressStr);
        }
        catch (Exception e) {
            LOGGER.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            model = CustomSql.getCustomSql(expressStr);
        }
        return model;
    }

    public static void verify(String expressStr, Map<String, Table> tableMap, List<SqlField> fieldList) {
        ExpressionParser parser = new ExpressionParser();
        parser.setTableMap(tableMap).setIsCheck(true).setFieldTypeInfo(fieldList);
        try {
            parser.parseExpression(expressStr);
        }
        catch (SQLBuildException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new SQLBuildException("\u8868\u8fbe\u5f0f\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static DataType verifyAndGetDataType(String expressStr, Map<String, Table> tableMap, List<SqlField> fieldList) {
        ExpressionParser parser = new ExpressionParser();
        parser.setTableMap(tableMap).setIsCheck(true).setFieldTypeInfo(fieldList);
        try {
            Model model = parser.parseExpression(expressStr);
            return ExpressionUtils.getModelDataType(model);
        }
        catch (SQLBuildException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new SQLBuildException("\u8868\u8fbe\u5f0f\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static List<SqlField> getFields(String expressStr, Map<String, Table> tableMap) {
        ExpressionParser parser = new ExpressionParser();
        parser.setTableMap(tableMap).setIsCountField(true);
        try {
            parser.parseExpression(expressStr);
        }
        catch (Exception e) {
            LOGGER.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new SQLBuildException("\u8868\u8fbe\u5f0f\u9a8c\u8bc1\u5931\u8d25");
        }
        return parser.getSqlFields();
    }

    private static DataType getModelDataType(Model model) {
        if (model instanceof CustomSql) {
            CustomSql customSql = (CustomSql)model;
            boolean flag = customSql.getSql().startsWith("'");
            if (flag) {
                return DataType.STRING;
            }
            if (RegexUtils.isMatchNumber(customSql.getSql())) {
                return DataType.NUMBER;
            }
        } else if (model instanceof Function) {
            Function function = (Function)model;
            FunctionType functionType = function.getFunctionType();
            return ExpressionUtils.getDataTypeByFunctionType(functionType);
        }
        return DataType.STRING;
    }

    private static DataType getDataTypeByFunctionType(FunctionType functionType) {
        switch (functionType) {
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case POWER: 
            case PERCENTAGE: 
            case ABS: 
            case MOD: 
            case ROUND: 
            case RAND: 
            case DATE_DIFF: {
                return DataType.NUMBER;
            }
            case CEIL: 
            case FLOOR: 
            case LENGTH: 
            case INSTR: {
                return DataType.INTEGER;
            }
            case STRING_TO_DATE: 
            case ADD_DATE_TIME: 
            case SUB_DATE_TIME: 
            case CURRENT_TIMESTAMP: {
                return DataType.TIMESTAMP;
            }
            case YEAR_BEGIN: 
            case YEAR_END: 
            case QUARTER_BEGIN: 
            case QUARTER_END: 
            case MONTH_BEGIN: 
            case MONTH_END: 
            case WEEK_BEGIN: 
            case WEEK_END: {
                return DataType.DATE;
            }
        }
        return DataType.STRING;
    }
}

