/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.alibaba.fastjson.JSONObject;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.FunctionCheckDefinition;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class FunCheckUtils {
    private static final Map<String, FunctionCheckDefinition> CACHE = new HashMap<String, FunctionCheckDefinition>();

    public static FunctionCheckDefinition getCheckDefinitionByName(String name) {
        return CACHE.get(name.toLowerCase());
    }

    public static String[] getDataType(String name, int index, int realSize) {
        FunctionCheckDefinition checkDefinition = FunCheckUtils.getCheckDefinitionByName(name);
        String[] checkRegexType = null;
        if (checkDefinition != null) {
            int max = checkDefinition.getMax();
            int min = checkDefinition.getMin();
            if (realSize < min || realSize > max) {
                if (min == max) {
                    throw new SQLBuildException("\u51fd\u6570" + name + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u9700\u8981\uff1a" + min + "\uff0c\u5b9e\u9645\uff1a" + realSize);
                }
                throw new SQLBuildException("\u51fd\u6570" + name + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u6700\u5c11\uff1a" + min + "\uff0c\u6700\u591a\uff1a" + max + "\uff0c\u5b9e\u9645\uff1a" + realSize);
            }
            List<FunctionCheckDefinition.CheckDetail> params = checkDefinition.getParams();
            if (params != null && params.size() > 0) {
                int size = params.size();
                checkRegexType = size > index ? params.get(index).getCheckRegexType() : params.get(size - 1).getCheckRegexType();
            }
        }
        return checkRegexType == null ? new String[]{} : checkRegexType;
    }

    static {
        String filename = "function_param_check.json";
        InputStream is = null;
        try {
            ClassPathResource resource = new ClassPathResource(filename);
            is = resource.getInputStream();
            String jsonStr = IOUtils.toString((InputStream)is, (String)"utf-8");
            List dataList = JSONObject.parseArray((String)jsonStr, FunctionCheckDefinition.class);
            if (dataList != null && dataList.size() > 0) {
                for (FunctionCheckDefinition data : dataList) {
                    CACHE.put(data.getName().toLowerCase(), data);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new SQLBuildException("\u52a0\u8f7d\u51fd\u6570\u53c2\u6570\u6821\u9a8c\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

