/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.alibaba.fastjson.JSONObject;
import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.FunctionType;
import com.sensesai.sql.exception.SQLBuildException;
import com.sensesai.sql.function.FunctionDefinition;
import com.sensesai.sql.function.FunctionDefinitionList;
import com.sensesai.sql.function.FunctionParamDefinition;
import com.sensesai.sql.function.IDatabaseFunction;
import com.sensesai.sql.model.AbstractFunction;
import com.sensesai.sql.model.Constant;
import com.sensesai.sql.model.CustomSql;
import com.sensesai.sql.model.Function;
import com.sensesai.sql.model.Model;
import com.sensesai.sql.util.Holder;
import com.sensesai.sql.util.PropertyUtils;
import com.sensesai.sql.util.RegexUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class FunctionUtils {
    private static final String FIXED = "fixed";
    private static final String RANGE = "range";

    public static String toDatabaseSql(DatabaseType databaseType, AbstractFunction abstractFunction) {
        String name = abstractFunction.getType().getCode();
        FunctionDefinition functionDefinition = FunctionUtils.getFunctionDefinition(databaseType, name);
        if (functionDefinition != null) {
            FunctionUtils.verifyParam(databaseType, abstractFunction, functionDefinition);
            return FunctionUtils.getDatabaseSqlByJson(databaseType, abstractFunction, functionDefinition);
        }
        return FunctionUtils.getDatabaseSqlByJava(databaseType, abstractFunction);
    }

    private static String getDatabaseSqlByJson(DatabaseType databaseType, AbstractFunction abstractFunction, FunctionDefinition functionDefinition) {
        if (abstractFunction instanceof Function) {
            Function function = (Function)abstractFunction;
            if (FIXED.equalsIgnoreCase(functionDefinition.getParamSizeType())) {
                Function function1 = FunctionUtils.dateFormatSpecialTreatment(databaseType, function);
                if (function1 != null) {
                    return FunctionUtils.getFixedFunctionSql(databaseType, functionDefinition.getFunction(), function1.getParamList());
                }
                return FunctionUtils.getFixedFunctionSql(databaseType, functionDefinition.getFunction(), function.getParamList());
            }
            return FunctionUtils.getRangeFunctionSql(databaseType, function, functionDefinition);
        }
        throw new SQLBuildException("\u8be5\u7c7b\u51fd\u6570\u6682\u4e0d\u53ef\u901a\u8fc7json\u914d\u7f6e");
    }

    private static Function dateFormatSpecialTreatment(DatabaseType databaseType, Function function) {
        if (FunctionType.DATE_TO_STRING == function.getFunctionType() || FunctionType.STRING_TO_DATE == function.getFunctionType()) {
            Model[] models = new Model[2];
            List<Model> paramList = function.getParamList();
            models[0] = paramList.get(0);
            models[1] = CustomSql.getCustomSql("'" + PropertyUtils.getDatabaseDateFormat(databaseType, paramList.get(1).getDatabaseSql(databaseType)) + "'");
            return Function.getFunction(function.getFunctionType(), models);
        }
        return null;
    }

    private static String getFixedFunctionSql(DatabaseType databaseType, String functionStr, List<Model> paramList) {
        String sql = functionStr;
        int size = paramList.size();
        for (int i = 0; i < size; ++i) {
            sql = sql.replaceAll("#" + (i + 1), paramList.get(i).getDatabaseSql(databaseType));
        }
        return sql;
    }

    private static String getRangeFunctionSql(DatabaseType databaseType, Function function, FunctionDefinition functionDefinition) {
        StringBuilder sql = new StringBuilder();
        sql.append(functionDefinition.getFunction());
        sql.append(functionDefinition.getLeftQuote());
        List<Model> paramList = function.getParamList();
        boolean isDiv = function.getFunctionType() == FunctionType.DIV;
        int size = paramList.size();
        for (int i = 0; i < size; ++i) {
            String str = paramList.get(i).getDatabaseSql(databaseType);
            if (isDiv && i > 0) {
                sql.append("(case when ").append(str).append("=0 then null").append(" else ").append(str).append(" end)");
            } else {
                sql.append(str);
            }
            if (i == size - 1) continue;
            sql.append(functionDefinition.getParamSplit());
        }
        sql.append(functionDefinition.getRightQuote());
        return sql.toString();
    }

    private static void verifyParam(DatabaseType databaseType, AbstractFunction abstractFunction, FunctionDefinition functionDefinition) {
        if (abstractFunction instanceof Function) {
            Function function = (Function)abstractFunction;
            List<Model> paramList = function.getParamList();
            String paramSizeType = functionDefinition.getParamSizeType();
            int paramMaxSize = functionDefinition.getParamMaxSize();
            int paramMinSize = functionDefinition.getParamMinSize();
            if (FIXED.equalsIgnoreCase(paramSizeType)) {
                if (paramMinSize != function.getParamList().size()) {
                    throw new SQLBuildException("\u51fd\u6570" + function.getFunctionType().getCode() + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u9700\u8981\uff1a" + paramMinSize + "\uff0c\u5b9e\u9645\uff1a" + paramList.size());
                }
            } else if (RANGE.equalsIgnoreCase(paramSizeType) && (paramList.size() < paramMinSize || paramList.size() > paramMaxSize)) {
                throw new SQLBuildException("\u51fd\u6570" + function.getFunctionType().getCode() + "\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u6700\u5c11\uff1a" + paramMinSize + "\uff0c\u6700\u591a" + paramMaxSize + "\uff0c\u5b9e\u9645\uff1a" + paramList.size());
            }
            String checkMsgPrefix = "\u51fd\u6570" + function.getFunctionType().getCode();
            FunctionUtils.isMatch(databaseType, checkMsgPrefix, paramList, functionDefinition.getParams());
        }
    }

    private static void isMatch(DatabaseType databaseType, String checkMsgPrefix, List<Model> paramList, List<FunctionParamDefinition> paramDefinitionList) {
        if (paramList == null || paramList.size() == 0 || paramDefinitionList == null || paramDefinitionList.size() == 0) {
            return;
        }
        int realSize = paramList.size();
        int needSize = paramDefinitionList.size();
        String checkMsg = "";
        for (int i = 0; i < realSize; ++i) {
            Model model = paramList.get(i);
            if (!(model instanceof Constant)) continue;
            FunctionParamDefinition functionParamDefinition = needSize > i ? paramDefinitionList.get(i) : paramDefinitionList.get(needSize - 1);
            String checkRegexType = functionParamDefinition.getCheckRegexType();
            checkMsg = functionParamDefinition.getCheckMsg();
            if (checkRegexType == null || "".equals(checkRegexType.trim()) || FunctionUtils.isMatchRegex(checkRegexType, ((Constant)model).getOriginalSql(databaseType))) continue;
            throw new SQLBuildException(checkMsgPrefix + "\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + checkMsg == null ? "" : checkMsg);
        }
    }

    private static boolean isMatchRegex(String regexTye, String str) {
        switch (regexTye.toLowerCase()) {
            case "int": {
                return RegexUtils.isMatchInt(str);
            }
            case "number": {
                return RegexUtils.isMatchNumber(str);
            }
        }
        return true;
    }

    private static String getDatabaseSqlByJava(DatabaseType databaseType, AbstractFunction function) {
        IDatabaseFunction javaFunction = FunctionUtils.getDatabaseFunction(databaseType);
        try {
            String methodName = FunctionUtils.getInvokeMethodName(function.getType());
            Method method = javaFunction.getClass().getMethod(methodName, AbstractFunction.class);
            Object invoke = method.invoke((Object)javaFunction, function);
            return (String)invoke;
        }
        catch (NoSuchMethodException e) {
            throw new SQLBuildException(databaseType.getCode() + "\u6570\u636e\u5e93\u51fd\u6570" + function.getType().getCode() + "\u6682\u672a\u5f00\u53d1", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLBuildException) {
                throw (SQLBuildException)cause;
            }
            throw new SQLBuildException(databaseType.getCode() + "\u6570\u636e\u5e93\u51fd\u6570" + function.getType().getCode() + "\u8c03\u7528\u5931\u8d25", e);
        }
    }

    private static String getInvokeMethodName(FunctionType functionType) {
        switch (functionType) {
            case STRING_TO_DATE: {
                return "strToDate";
            }
            case DATE_TO_STRING: {
                return "dateFormat";
            }
            case DATE_DIFF: {
                return "dateDiff";
            }
        }
        return functionType.getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FunctionDefinition getFunctionDefinition(DatabaseType databaseType, String name) {
        String key = databaseType.getCode() + "_functionDefinition";
        Holder holder = Holder.getOrCreateHolder(key);
        Map<String, FunctionDefinition> instance = (Map<String, FunctionDefinition>)holder.get();
        if (Objects.isNull(instance)) {
            Holder holder2 = holder;
            synchronized (holder2) {
                if (Objects.isNull(instance)) {
                    instance = FunctionUtils.loadFunction(databaseType);
                    holder.set(instance);
                }
            }
        }
        return (FunctionDefinition)instance.get(name);
    }

    private static Map<String, FunctionDefinition> loadFunction(DatabaseType databaseType) {
        HashMap<String, FunctionDefinition> hashMap;
        HashMap<String, FunctionDefinition> functionDefinitionMap = new HashMap<String, FunctionDefinition>();
        String filename = databaseType.getCode().toLowerCase() + "_function.json";
        InputStream is = null;
        try {
            ClassPathResource resource = new ClassPathResource(filename);
            is = resource.getInputStream();
            String jsonStr = IOUtils.toString((InputStream)is, (String)"utf-8");
            FunctionDefinitionList functionDefinitionList = (FunctionDefinitionList)JSONObject.parseObject((String)jsonStr, FunctionDefinitionList.class);
            if (functionDefinitionList.getFunctions() != null && functionDefinitionList.getFunctions().size() > 0) {
                for (FunctionDefinition functionDefinition : functionDefinitionList.getFunctions()) {
                    functionDefinitionMap.put(functionDefinition.getName(), functionDefinition);
                }
            }
            hashMap = functionDefinitionMap;
        }
        catch (Exception e) {
            try {
                throw new SQLBuildException("\u52a0\u8f7d\u51fd\u6570\u5b9a\u4e49\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDatabaseFunction getDatabaseFunction(DatabaseType databaseType) {
        String key = "databaseFunction";
        Holder holder = Holder.getOrCreateHolder(key);
        HashMap<DatabaseType, IDatabaseFunction> instance = (HashMap<DatabaseType, IDatabaseFunction>)holder.get();
        if (Objects.isNull(instance)) {
            Holder holder2 = holder;
            synchronized (holder2) {
                if (Objects.isNull(instance)) {
                    ServiceLoader<IDatabaseFunction> serviceLoader = ServiceLoader.load(IDatabaseFunction.class);
                    Iterator<IDatabaseFunction> it = serviceLoader.iterator();
                    instance = new HashMap<DatabaseType, IDatabaseFunction>();
                    while (it.hasNext()) {
                        IDatabaseFunction next = it.next();
                        instance.putIfAbsent(next.getDatabaseType(), next);
                    }
                    holder.set(instance);
                }
            }
        }
        return (IDatabaseFunction)instance.get((Object)databaseType);
    }
}

