/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.sensesai.sql.enums.DatabaseType;
import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.enums.TimeUnitType;
import com.sensesai.sql.exception.SQLBuildException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class PropertyUtils {
    private static final String DATE_FORMAT = "dateformat.";
    private static final String TIME_UNIT = "timeUnit.";
    private static volatile Properties properties;

    public static String getDatabaseDateFormat(DatabaseType databaseType, DateFormatType dateFormatType) {
        String key = DATE_FORMAT + databaseType.getCode() + "." + PropertyUtils.getDateFormatTypePropertyCode(dateFormatType);
        String value = PropertyUtils.getValue(key);
        if ("".equals(value)) {
            throw new SQLBuildException(databaseType.getCode() + "\u6682\u4e0d\u652f\u6301" + dateFormatType.getName() + "\u65f6\u95f4\u683c\u5f0f");
        }
        return value;
    }

    public static String getDatabaseDateFormat(DatabaseType databaseType, String str) {
        String code = str.replaceAll("'", "");
        DateFormatType dateFormatType = DateFormatType.getEnumByCode(code);
        return PropertyUtils.getDatabaseDateFormat(databaseType, dateFormatType);
    }

    public static String getDatabaseTimeUnit(DatabaseType databaseType, TimeUnitType type) {
        String key = TIME_UNIT + databaseType.getCode() + "." + type.getCode();
        String value = PropertyUtils.getValue(key);
        if ("".equals(value)) {
            throw new SQLBuildException(databaseType.getCode() + "\u6570\u636e\u5e93\u6682\u4e0d\u652f\u6301" + type.getCode() + "\u65f6\u95f4\u5355\u4f4d");
        }
        return value;
    }

    private static String getDateFormatTypePropertyCode(DateFormatType dateFormatType) {
        switch (dateFormatType) {
            case YYYY_MM_DD_HH24_MI_SS: {
                return "1";
            }
            case YYYYMMDDHH24MISS: {
                return "2";
            }
            case YYYY_MM_DD: {
                return "3";
            }
            case YYYYMMDD: {
                return "4";
            }
            case HH24_MI_SS: {
                return "5";
            }
            case HH24MISS: {
                return "6";
            }
        }
        return "";
    }

    private static String getValue(String key) {
        Object o = properties.get(key);
        if (Objects.nonNull(o)) {
            return String.valueOf(o);
        }
        return "";
    }

    static {
        String filename = "database.properties";
        InputStream is = null;
        try {
            ClassPathResource resource = new ClassPathResource(filename);
            is = resource.getInputStream();
            properties = new Properties();
            properties.load(is);
        }
        catch (Exception e) {
            try {
                throw new SQLBuildException("\u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

