/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import com.sensesai.sql.enums.DateFormatType;
import com.sensesai.sql.enums.TimeUnitType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    private static final Pattern INT = Pattern.compile("(-)?(\\d){1,}");
    private static final Pattern NUMBER = Pattern.compile("-?((\\d)|([1-9]\\d*\\.\\d{1,})|0\\.\\d{1,})");
    private static final Pattern VARCHAR = Pattern.compile("'([\\s\\S]*)'");
    private static final Pattern DATETIME_VARCHAR = Pattern.compile("'((\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2})|(\\d{14}))'");
    private static final Pattern DATE_VARCHAR = Pattern.compile("'((\\d{8})|(\\d{4}-\\d{2}-\\d{2}))'");
    private static final Pattern TIME_VARCHAR = Pattern.compile("'((\\d{6})|(\\d{2}:\\d{2}:\\d{2}))'");

    public static boolean isMatchInt(String value) {
        Matcher matcher = INT.matcher(value);
        return matcher.matches();
    }

    public static boolean isMatchNumber(String value) {
        Matcher matcher = NUMBER.matcher(value);
        return matcher.matches();
    }

    public static boolean isMatchVarchar(String value) {
        Matcher matcher = VARCHAR.matcher(value);
        return matcher.matches();
    }

    public static boolean isMatchDateFormat(String value) {
        DateFormatType[] values;
        if (value == null) {
            return false;
        }
        if (!value.startsWith("'") || !value.endsWith("'")) {
            return false;
        }
        String str = value.replaceAll("'", "");
        for (DateFormatType type : values = DateFormatType.values()) {
            if (!type.getCode().equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchTimeUnit(String value) {
        TimeUnitType[] values;
        if (value == null) {
            return false;
        }
        if (!value.startsWith("'") || !value.endsWith("'")) {
            return false;
        }
        String str = value.replaceAll("'", "");
        for (TimeUnitType type : values = TimeUnitType.values()) {
            if (!type.getCode().equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchDateTimeVarchar(String value) {
        Matcher matcher = DATETIME_VARCHAR.matcher(value);
        return matcher.matches();
    }

    public static boolean isMatchDateVarchar(String value) {
        Matcher matcher = DATE_VARCHAR.matcher(value);
        return matcher.matches();
    }

    public static boolean isMatchTimeVarchar(String value) {
        Matcher matcher = TIME_VARCHAR.matcher(value);
        return matcher.matches();
    }
}

