/*
 * Decompiled with CFR 0.152.
 */
package com.sensesai.sql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScriptSplitUtils {
    public static List<String> split(String scriptStr) {
        ScriptSplitter scriptSplit = new ScriptSplitter(scriptStr);
        return scriptSplit.split();
    }

    private static class ScriptSplitter {
        private static final char SEMICOLON = ';';
        private static final char DASH = '-';
        private static final char SLASH = '/';
        private static final char STAR = '*';
        private static final char SINGLE_QUOTE = '\'';
        private static final char DOUBLE_QUOTE = '\"';
        private final String scriptStr;
        private boolean inSingleLineComment;
        private boolean inMultiLineComment;
        private boolean inSingleQuotes;
        private boolean inDoubleQuotes;
        private boolean ignoreComment = true;
        private char ch;
        private char next;

        ScriptSplitter(String scriptStr) {
            if (Objects.isNull(scriptStr) || "".equals(scriptStr.trim())) {
                throw new RuntimeException("\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.scriptStr = scriptStr;
        }

        public List<String> split() {
            ArrayList<String> result = new ArrayList<String>();
            int len = this.scriptStr.length();
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                this.ch = this.scriptStr.charAt(i);
                this.next = this.charAt(i + 1, len, this.scriptStr);
                boolean isEndComment = false;
                if (this.isStartSingleComment()) {
                    this.inSingleLineComment = true;
                }
                if (this.isEndSingleComment()) {
                    this.inSingleLineComment = false;
                }
                if (this.isStartMultiComment()) {
                    this.inMultiLineComment = true;
                }
                if (this.isEndMultiComment()) {
                    this.inMultiLineComment = false;
                    isEndComment = true;
                    if (this.ignoreComment) {
                        ++i;
                    }
                }
                if (this.isSingleQuote()) {
                    boolean bl = this.inSingleQuotes = !this.inSingleQuotes;
                }
                if (this.isDoubleQuote()) {
                    boolean bl = this.inDoubleQuotes = !this.inDoubleQuotes;
                }
                if (this.isNewScript()) {
                    this.addSql(result, tmp);
                    tmp = new StringBuilder();
                    continue;
                }
                if (this.ignoreComment && (this.inSingleLineComment || this.inMultiLineComment || isEndComment)) continue;
                tmp.append(this.ch);
            }
            this.addSql(result, tmp);
            return result;
        }

        private boolean isStartSingleComment() {
            boolean flag = !this.inMultiLineComment && !this.inSingleQuotes && !this.inDoubleQuotes;
            return !this.inSingleLineComment && flag && this.ch == '-' && this.next == '-';
        }

        private boolean isEndSingleComment() {
            boolean flag = !this.inMultiLineComment && !this.inSingleQuotes && !this.inDoubleQuotes;
            return this.inSingleLineComment && flag && this.isNewLineChar(this.ch);
        }

        private boolean isStartMultiComment() {
            boolean flag = !this.inSingleLineComment && !this.inSingleQuotes && !this.inDoubleQuotes;
            return flag && this.ch == '/' && this.next == '*';
        }

        private boolean isEndMultiComment() {
            boolean flag = !this.inSingleLineComment && !this.inSingleQuotes && !this.inDoubleQuotes;
            return this.inMultiLineComment && flag && this.ch == '*' && this.next == '/';
        }

        private boolean isSingleQuote() {
            boolean flag = !this.inSingleLineComment && !this.inMultiLineComment && !this.inDoubleQuotes;
            return flag && this.ch == '\'';
        }

        private boolean isDoubleQuote() {
            boolean flag = !this.inSingleLineComment && !this.inMultiLineComment && !this.inSingleQuotes;
            return flag && this.ch == '\"';
        }

        private boolean isNewScript() {
            boolean flag = !this.inSingleLineComment && !this.inMultiLineComment && !this.inSingleQuotes && !this.inDoubleQuotes;
            return ';' == this.ch && flag;
        }

        private char charAt(int index, int len, String str) {
            if (index < len) {
                return str.charAt(index);
            }
            return ' ';
        }

        private boolean isNewLineChar(char ch) {
            return '\n' == ch || '\r' == ch || '\t' == ch;
        }

        private void addSql(List<String> result, StringBuilder tmp) {
            String sql = tmp.toString();
            if (Objects.nonNull(sql) && !"".equals(sql = sql.trim())) {
                result.add(sql);
            }
        }
    }
}

