/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.files;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import pl.edu.icm.unity.engine.api.files.IllegalURIException;

public class URIHelper {
    public static final Set<String> SUPPORTED_LOCAL_FILE_SCHEMES = new HashSet<String>(Arrays.asList("file", "unity.internal"));
    public static final Set<String> SUPPORTED_URL_SCHEMES = new HashSet<String>(Arrays.asList("data", "http", "https"));

    public static URI parseURI(String rawURI) throws IllegalURIException {
        URI uri;
        try {
            uri = new URI(rawURI);
        }
        catch (URISyntaxException e) {
            throw new IllegalURIException("Not supported uri schema");
        }
        URIHelper.validateURI(uri);
        return uri;
    }

    public static void validateURI(URI uri) throws IllegalURIException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.isEmpty() || SUPPORTED_LOCAL_FILE_SCHEMES.contains(scheme) || SUPPORTED_URL_SCHEMES.contains(scheme)) {
            return;
        }
        throw new IllegalURIException("Unknown scheme");
    }

    public static boolean isWebReady(String rawURI) {
        URI uri;
        try {
            uri = URIHelper.parseURI(rawURI);
        }
        catch (IllegalURIException e) {
            return false;
        }
        return URIHelper.isWebReady(uri);
    }

    public static boolean isWebReady(URI uri) {
        String scheme;
        return uri != null && uri.getScheme() != null && SUPPORTED_URL_SCHEMES.contains(scheme = uri.getScheme());
    }

    public static String getPathFromURI(URI uri) {
        return uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
    }
}

