/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation.out;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.types.basic.Attribute;
import pl.edu.icm.unity.types.basic.Entity;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.basic.Identity;

public class TranslationInput {
    private Collection<Attribute> attributes;
    private Entity entity;
    private String chosenGroup;
    private Set<Group> groups;
    private String requester;
    private Collection<Attribute> requesterAttributes;
    private String protocol;
    private String protocolSubType;
    private Map<String, AuthenticationResult.Status> importStatus;

    public TranslationInput(Collection<? extends Attribute> attributes, Entity entity, String chosenGroup, Collection<Group> groups, String requester, Collection<? extends Attribute> requesterAttributes, String protocol, String protocolSubType, Map<String, AuthenticationResult.Status> importStatus) {
        this.requesterAttributes = Lists.newArrayList(requesterAttributes);
        this.importStatus = importStatus;
        this.attributes = Lists.newArrayList(attributes);
        this.entity = entity;
        this.chosenGroup = chosenGroup;
        this.groups = new HashSet<Group>();
        this.groups.addAll(groups);
        this.requester = requester;
        this.protocol = protocol;
        this.protocolSubType = protocolSubType;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public String getRequester() {
        return this.requester;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProtocolSubType() {
        return this.protocolSubType;
    }

    public String getChosenGroup() {
        return this.chosenGroup;
    }

    public Map<String, AuthenticationResult.Status> getImportStatus() {
        return this.importStatus;
    }

    public void setImportStatus(Map<String, AuthenticationResult.Status> importStatus) {
        this.importStatus = importStatus;
    }

    public Collection<Attribute> getRequesterAttributes() {
        return this.requesterAttributes;
    }

    public String toString() {
        return this.requester + " - eId: " + this.entity.getId();
    }

    public String getTextDump() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entity " + this.entity.getId() + ":\n");
        for (Identity identity : this.entity.getIdentities()) {
            sb.append(" - ").append(identity.toString()).append("\n");
        }
        if (!this.attributes.isEmpty()) {
            sb.append("Attributes:\n");
            for (Attribute attribute : this.attributes) {
                sb.append(" - ").append(attribute).append("\n");
            }
        }
        sb.append("In group: " + this.chosenGroup + "\n");
        if (!this.groups.isEmpty()) {
            sb.append("Groups: " + this.groups + "\n");
        }
        if (!this.importStatus.isEmpty()) {
            sb.append("User import status:\n");
            for (Map.Entry entry : this.importStatus.entrySet()) {
                sb.append(" - ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        sb.append("Requester: " + this.requester + "\n");
        if (!this.requesterAttributes.isEmpty()) {
            sb.append("Requester attributes:\n");
            for (Attribute attribute : this.requesterAttributes) {
                sb.append(" - ").append(attribute).append("\n");
            }
        }
        sb.append("Protocol: " + this.protocol + ":" + this.protocolSubType);
        return sb.toString();
    }
}

