/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;

public class RoutingServlet
extends HttpServlet {
    private static final Logger log = Log.getLogger((String)"unity.server", RoutingServlet.class);
    public static final String CURRENT_DESTINATION = RoutingServlet.class.getName() + ".destination";
    private String defaultTarget;

    public RoutingServlet(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String destination;
        HttpSession session = req.getSession(false);
        if (session != null && (destination = (String)session.getAttribute(CURRENT_DESTINATION)) != null) {
            log.debug("Routing request to regular destination " + destination);
            req.getRequestDispatcher(this.constructPath(destination, req)).forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        log.debug("Routing request to DEFAULT destination " + this.defaultTarget);
        req.getRequestDispatcher(this.constructPath(this.defaultTarget, req)).forward((ServletRequest)req, (ServletResponse)resp);
    }

    private String constructPath(String destination, HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        return pathInfo == null ? destination : destination + pathInfo;
    }

    public static void forwardTo(String newDestination, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.getSession().setAttribute(CURRENT_DESTINATION, (Object)newDestination);
        req.getRequestDispatcher(newDestination).forward((ServletRequest)req, (ServletResponse)resp);
    }

    public static void clean(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.removeAttribute(CURRENT_DESTINATION);
        }
    }
}

