/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.Objects;

public class AuthenticationSubject {
    public final String identity;
    public final Long entityId;

    private AuthenticationSubject(String identity, Long entityId) {
        this.identity = identity;
        this.entityId = entityId;
    }

    public static AuthenticationSubject identityBased(String identity) {
        return new AuthenticationSubject(identity, null);
    }

    public static AuthenticationSubject entityBased(long entityId) {
        return new AuthenticationSubject(null, entityId);
    }

    public String toString() {
        return this.identity == null ? String.valueOf(this.entityId) : this.identity;
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.identity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationSubject other = (AuthenticationSubject)obj;
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.identity, other.identity);
    }
}

