/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.base.token.Token;

public class LoginSession {
    private String id;
    private Date started;
    private Date expires;
    private Date lastUsed;
    private long maxInactivity;
    private long entityId;
    private String realm;
    private String outdatedCredentialId;
    private String entityLabel;
    private Set<String> authenticatedIdentities = new LinkedHashSet<String>();
    private String remoteIdP;
    private RememberMeInfo rememberMeInfo;
    private AuthNInfo login1stFactor;
    private AuthNInfo login2ndFactor;
    private AuthNInfo additionalAuthn;
    private Map<String, String> sessionData = new HashMap<String, String>();

    public LoginSession() {
    }

    public LoginSession(String id, Date started, Date expires, long maxInactivity, long entityId, String realm, RememberMeInfo rememberMeInfo, AuthNInfo login1stFactor, AuthNInfo login2ndFactor) {
        this.id = id;
        this.started = started;
        this.entityId = entityId;
        this.realm = realm;
        this.login1stFactor = login1stFactor;
        this.login2ndFactor = login2ndFactor;
        this.lastUsed = new Date();
        this.expires = expires;
        this.maxInactivity = maxInactivity;
        this.rememberMeInfo = rememberMeInfo;
    }

    public LoginSession(String id, Date started, long maxInactivity, long entityId, String realm, RememberMeInfo rememberMeInfo, AuthNInfo login1stFactor, AuthNInfo login2ndFactor) {
        this(id, started, null, maxInactivity, entityId, realm, rememberMeInfo, login1stFactor, login2ndFactor);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date started) {
        this.started = started;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, String> getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Map<String, String> sessionData) {
        this.sessionData = sessionData;
    }

    public Date getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getMaxInactivity() {
        return this.maxInactivity;
    }

    public void setMaxInactivity(long maxInactivity) {
        this.maxInactivity = maxInactivity;
    }

    public String getEntityLabel() {
        return this.entityLabel;
    }

    public void setEntityLabel(String entityLabel) {
        this.entityLabel = entityLabel;
    }

    public Set<String> getAuthenticatedIdentities() {
        return this.authenticatedIdentities;
    }

    public void addAuthenticatedIdentities(Collection<String> identity) {
        this.authenticatedIdentities.addAll(identity);
    }

    public String getRemoteIdP() {
        return this.remoteIdP;
    }

    public void setRemoteIdP(String remoteIdP) {
        this.remoteIdP = remoteIdP;
    }

    public String getOutdatedCredentialId() {
        return this.outdatedCredentialId;
    }

    public boolean isUsedOutdatedCredential() {
        return this.outdatedCredentialId != null;
    }

    public void setOutdatedCredentialId(String outdatedCredentialId) {
        this.outdatedCredentialId = outdatedCredentialId;
    }

    public RememberMeInfo getRememberMeInfo() {
        return this.rememberMeInfo;
    }

    public void setRememberMeInfo(RememberMeInfo rememberMeInfo) {
        this.rememberMeInfo = rememberMeInfo;
    }

    public AuthNInfo getLogin1stFactor() {
        return this.login1stFactor;
    }

    public String getLogin1stFactorOptionId() {
        return this.login1stFactor == null ? null : this.login1stFactor.optionId;
    }

    public void setLogin1stFactor(AuthNInfo login1stFactor) {
        this.login1stFactor = login1stFactor;
    }

    public AuthNInfo getLogin2ndFactor() {
        return this.login2ndFactor;
    }

    public String getLogin2ndFactorOptionId() {
        return this.login2ndFactor == null ? null : this.login2ndFactor.optionId;
    }

    public void setLogin2ndFactor(AuthNInfo login2ndFactor) {
        this.login2ndFactor = login2ndFactor;
    }

    public AuthNInfo getAdditionalAuthn() {
        return this.additionalAuthn;
    }

    public void setAdditionalAuthn(AuthNInfo additionalAuthn) {
        this.additionalAuthn = additionalAuthn;
    }

    public boolean isExpiredAt(long timestamp) {
        long inactiveFor = timestamp - this.getLastUsed().getTime();
        return inactiveFor > this.getMaxInactivity();
    }

    public void deserialize(Token token) {
        ObjectNode main = JsonUtil.parse((byte[])token.getContents());
        String realm = main.get("realm").asText();
        long maxInactive = main.get("maxInactivity").asLong();
        long lastUsed = main.get("lastUsed").asLong();
        String entityLabel = main.get("entityLabel").asText();
        String credentialId = null;
        if (main.has("outdatedCredentialId")) {
            credentialId = main.get("outdatedCredentialId").asText();
        }
        if (main.has("authenticatedIdentities")) {
            ArrayList<String> ai = new ArrayList<String>(2);
            ArrayNode an = (ArrayNode)main.get("authenticatedIdentities");
            for (int i = 0; i < an.size(); ++i) {
                ai.add(an.get(i).asText());
            }
            this.addAuthenticatedIdentities(ai);
        }
        if (main.has("remoteIdP")) {
            this.setRemoteIdP(main.get("remoteIdP").asText());
        }
        if (main.has("login1stFactor")) {
            this.login1stFactor = (AuthNInfo)Constants.MAPPER.convertValue((Object)main.get("login1stFactor"), AuthNInfo.class);
        }
        if (main.has("login2ndFactor")) {
            this.login2ndFactor = (AuthNInfo)Constants.MAPPER.convertValue((Object)main.get("login2ndFactor"), AuthNInfo.class);
        }
        if (main.has("additionalAuthn")) {
            this.additionalAuthn = (AuthNInfo)Constants.MAPPER.convertValue((Object)main.get("additionalAuthn"), AuthNInfo.class);
        }
        if (main.has("rememberMeInfo")) {
            this.rememberMeInfo = (RememberMeInfo)Constants.MAPPER.convertValue((Object)main.get("rememberMeInfo"), RememberMeInfo.class);
        }
        this.setId(token.getValue());
        this.setStarted(token.getCreated());
        this.setExpires(token.getExpires());
        this.setMaxInactivity(maxInactive);
        this.setEntityId(token.getOwner());
        this.setRealm(realm);
        this.setLastUsed(new Date(lastUsed));
        this.setEntityLabel(entityLabel);
        this.setOutdatedCredentialId(credentialId);
        HashMap<String, String> attrs = new HashMap<String, String>();
        ObjectNode attrsJson = (ObjectNode)main.get("attributes");
        Iterator fNames = attrsJson.fieldNames();
        while (fNames.hasNext()) {
            String attrName = (String)fNames.next();
            attrs.put(attrName, attrsJson.get(attrName).asText());
        }
        this.setSessionData(attrs);
    }

    public byte[] getTokenContents() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        main.put("realm", this.getRealm());
        main.put("maxInactivity", this.getMaxInactivity());
        main.put("lastUsed", this.getLastUsed().getTime());
        if (this.isUsedOutdatedCredential()) {
            main.put("outdatedCredentialId", this.getOutdatedCredentialId());
        }
        main.put("entityLabel", this.getEntityLabel());
        ArrayNode ai = main.withArray("authenticatedIdentities");
        for (String id : this.authenticatedIdentities) {
            ai.add(id);
        }
        if (this.remoteIdP != null) {
            main.put("remoteIdP", this.remoteIdP);
        }
        ObjectNode attrsJson = main.putObject("attributes");
        for (Map.Entry<String, String> a : this.getSessionData().entrySet()) {
            attrsJson.put(a.getKey(), a.getValue());
        }
        if (this.login1stFactor != null) {
            main.putPOJO("login1stFactor", (Object)this.login1stFactor);
        }
        if (this.login2ndFactor != null) {
            main.putPOJO("login2ndFactor", (Object)this.login2ndFactor);
        }
        if (this.additionalAuthn != null) {
            main.putPOJO("additionalAuthn", (Object)this.additionalAuthn);
        }
        if (this.rememberMeInfo != null) {
            main.putPOJO("rememberMeInfo", (Object)this.rememberMeInfo);
        }
        return JsonUtil.serialize2Bytes((JsonNode)main);
    }

    public String toString() {
        return this.id + "@" + this.realm + " of entity " + this.entityId;
    }

    public static class AuthNInfo {
        public final String optionId;
        public final Date time;

        @JsonCreator
        public AuthNInfo(@JsonProperty(value="optionId") String optionId, @JsonProperty(value="time") Date time) {
            this.optionId = optionId;
            this.time = time;
        }

        public String toString() {
            return "AuthNInfo [optionId=" + this.optionId + ", time=" + this.time.getTime() + "]";
        }
    }

    public static class RememberMeInfo {
        public final boolean firstFactorSkipped;
        public final boolean secondFactorSkipped;

        @JsonCreator
        public RememberMeInfo(@JsonProperty(value="firstFactorSkipped") boolean firstFactorSkipped, @JsonProperty(value="secondFactorSkipped") boolean secondFactorSkipped) {
            this.firstFactorSkipped = firstFactorSkipped;
            this.secondFactorSkipped = secondFactorSkipped;
        }
    }
}

