/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;

public class UnsuccessfulAuthenticationCounter {
    private static final Logger log = Log.getLogger((String)"unity.server", UnsuccessfulAuthenticationCounter.class);
    private int maxAttepts;
    private long blockTime;
    private Map<String, ClientInfo> accessMap;

    public UnsuccessfulAuthenticationCounter(int maxAttepts, long blockTime) {
        this.maxAttepts = maxAttepts;
        this.blockTime = blockTime;
        this.accessMap = new HashMap<String, ClientInfo>(64);
    }

    public synchronized long getRemainingBlockedTime(String ip) {
        ClientInfo clientInfo = this.accessMap.get(ip);
        if (clientInfo == null || clientInfo.blockedStartTime == -1L) {
            return 0L;
        }
        long blockedFor = System.currentTimeMillis() - clientInfo.blockedStartTime;
        if (blockedFor >= this.blockTime) {
            this.accessMap.remove(ip);
            return 0L;
        }
        return this.blockTime - blockedFor;
    }

    public synchronized void unsuccessfulAttempt(String ip) {
        ClientInfo clientInfo = this.accessMap.get(ip);
        if (clientInfo == null) {
            clientInfo = new ClientInfo();
            this.accessMap.put(ip, clientInfo);
        }
        clientInfo.unsuccessfulAttempts++;
        log.trace("New unsuccessful attempts count for " + ip + " is " + clientInfo.unsuccessfulAttempts);
        if (clientInfo.unsuccessfulAttempts >= this.maxAttepts) {
            log.info("Blocking access for IP " + ip + " after " + clientInfo.unsuccessfulAttempts + " unsuccessful login attempts for " + this.blockTime + "ms");
            clientInfo.blockedStartTime = System.currentTimeMillis();
        }
    }

    public synchronized void successfulAttempt(String ip) {
        log.trace("Cleaning unsuccessful attempts for " + ip);
        this.accessMap.remove(ip);
    }

    private static class ClientInfo {
        private int unsuccessfulAttempts = 0;
        private long blockedStartTime = -1L;

        private ClientInfo() {
        }
    }
}

