/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAuthnState;
import pl.edu.icm.unity.exceptions.WrongArgumentException;

public class RemoteAuthenticationContextManagement<T extends RemoteAuthnState> {
    public static final long MAX_TTL = 54000000L;
    public static final long CLEANUP_INTERVAL = 3600000L;
    private Map<String, T> contexts = new HashMap<String, T>();
    private Date lastCleanup = new Date();

    public synchronized void addAuthnContext(T context) {
        this.cleanup();
        String relayState = ((RemoteAuthnState)context).getRelayState();
        if (this.contexts.containsKey(relayState)) {
            throw new IllegalArgumentException("Ups, the relay state " + relayState + " is already assigned");
        }
        this.contexts.put(relayState, context);
    }

    public synchronized T getAuthnContext(String relayState) throws WrongArgumentException {
        this.cleanup();
        RemoteAuthnState ret = (RemoteAuthnState)this.contexts.get(relayState);
        if (ret == null) {
            throw new WrongArgumentException("The relay state " + relayState + " is not assigned");
        }
        return (T)ret;
    }

    public synchronized void removeAuthnContext(String relayState) {
        this.contexts.remove(relayState);
    }

    private void cleanup() {
        long now = System.currentTimeMillis();
        if (new Date(now - 3600000L).before(this.lastCleanup)) {
            return;
        }
        this.lastCleanup = new Date(now);
        Date oldestAllowed = new Date(now - 54000000L);
        Iterator<T> it = this.contexts.values().iterator();
        while (it.hasNext()) {
            RemoteAuthnState ctx = (RemoteAuthnState)it.next();
            if (!ctx.getCreationTime().before(oldestAllowed)) continue;
            it.remove();
        }
    }
}

