/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.idp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.config.UnityPropertiesHelper;
import pl.edu.icm.unity.engine.api.idp.IdpPolicyAgreementsConfiguration;
import pl.edu.icm.unity.types.I18nString;
import pl.edu.icm.unity.types.policyAgreement.PolicyAgreementConfiguration;
import pl.edu.icm.unity.types.policyAgreement.PolicyAgreementPresentationType;

public class IdpPolicyAgreementsConfigurationParser {
    public static Properties toProperties(MessageSource msg, IdpPolicyAgreementsConfiguration config, String prefix) {
        Properties ret = new Properties();
        if (config.title != null && !config.title.isEmpty()) {
            config.title.toProperties(ret, prefix + "policyAgreementsTitle", msg);
        }
        if (config.information != null && !config.information.isEmpty()) {
            config.information.toProperties(ret, prefix + "policyAgreementsInfo", msg);
        }
        ret.put(prefix + "policyAgreementsWidth", String.valueOf(config.width));
        ret.put(prefix + "policyAgreementsWidthUnit", config.widthUnit);
        for (PolicyAgreementConfiguration agreement : config.agreements) {
            ret.putAll((Map<?, ?>)IdpPolicyAgreementsConfigurationParser.policyAgreementConfigurationtoProperties(msg, prefix + "policyAgreements." + (config.agreements.indexOf(agreement) + 1) + ".", agreement));
        }
        return ret;
    }

    public static IdpPolicyAgreementsConfiguration fromPropoerties(MessageSource msg, UnityPropertiesHelper properties) {
        I18nString title = properties.getLocalizedStringWithoutFallbackToDefault(msg, "policyAgreementsTitle");
        I18nString information = properties.getLocalizedStringWithoutFallbackToDefault(msg, "policyAgreementsInfo");
        int width = properties.getIntValue("policyAgreementsWidth");
        String widthUnit = properties.getValue("policyAgreementsWidthUnit");
        ArrayList<PolicyAgreementConfiguration> agreements = new ArrayList<PolicyAgreementConfiguration>();
        for (String key : properties.getStructuredListKeys("policyAgreements.")) {
            PolicyAgreementConfiguration config = IdpPolicyAgreementsConfigurationParser.policyAgreementConfigurationfromProperties(msg, properties, key);
            agreements.add(config);
        }
        return new IdpPolicyAgreementsConfiguration(title, information, width, widthUnit, agreements);
    }

    private static PolicyAgreementConfiguration policyAgreementConfigurationfromProperties(MessageSource msg, UnityPropertiesHelper properties, String prefix) {
        String docsP = properties.getValue(prefix + "policyDocuments");
        ArrayList docs = new ArrayList();
        if (docsP != null && !docsP.isEmpty()) {
            docs.addAll(Arrays.asList(docsP.split(" ")).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList()));
        }
        PolicyAgreementPresentationType presentationType = (PolicyAgreementPresentationType)properties.getEnumValue(prefix + "policyAgreementPresentationType", PolicyAgreementPresentationType.class);
        I18nString text = properties.getLocalizedStringWithoutFallbackToDefault(msg, prefix + "text");
        return new PolicyAgreementConfiguration(docs, presentationType, text);
    }

    private static Properties policyAgreementConfigurationtoProperties(MessageSource msg, String prefix, PolicyAgreementConfiguration config) {
        Properties p = new Properties();
        p.put(prefix + "policyDocuments", String.join((CharSequence)" ", config.documentsIdsToAccept.stream().map(id -> String.valueOf(id)).collect(Collectors.toList())));
        p.put(prefix + "policyAgreementPresentationType", config.presentationType.toString());
        config.text.toProperties(p, prefix + "text", msg);
        return p;
    }
}

