/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.policyAgreement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import java.util.Objects;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.policyAgreement.PolicyAgreementAcceptanceStatus;

public class PolicyAgreementState {
    public final long policyDocumentId;
    public final int policyDocumentRevision;
    public final PolicyAgreementAcceptanceStatus acceptanceStatus;
    public final Date decisionTs;

    @JsonCreator
    public PolicyAgreementState(@JsonProperty(value="policyDocumentId") Long policyDocumentId, @JsonProperty(value="policyDocumentRevision") Integer policyDocumentRevision, @JsonProperty(value="acceptanceStatus") PolicyAgreementAcceptanceStatus acceptanceStatus, @JsonProperty(value="decisionTs") Date decisionTs) {
        this.policyDocumentId = policyDocumentId;
        this.policyDocumentRevision = policyDocumentRevision;
        this.acceptanceStatus = acceptanceStatus;
        this.decisionTs = decisionTs;
    }

    public String toJson() throws EngineException {
        try {
            return Constants.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new EngineException("Can not save policy agreement state value");
        }
    }

    public static PolicyAgreementState fromJson(String jsonConfig) throws EngineException {
        try {
            return (PolicyAgreementState)Constants.MAPPER.readValue(jsonConfig, PolicyAgreementState.class);
        }
        catch (Exception e) {
            throw new EngineException("Can not parse policy agreement state value");
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof PolicyAgreementState)) {
            return false;
        }
        PolicyAgreementState castOther = (PolicyAgreementState)other;
        return Objects.equals(this.policyDocumentId, castOther.policyDocumentId) && Objects.equals(this.policyDocumentRevision, castOther.policyDocumentRevision) && Objects.equals(this.acceptanceStatus, castOther.acceptanceStatus) && Objects.equals(this.decisionTs, castOther.decisionTs);
    }

    public int hashCode() {
        return Objects.hash(this.policyDocumentId, this.policyDocumentRevision, this.acceptanceStatus, this.decisionTs);
    }
}

