/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.registration;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.AntPathMatcher;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.registration.GroupRegistrationParam;

public class GroupPatternMatcher {
    public static boolean matches(String group, String pattern) {
        AntPathMatcher matcher = new AntPathMatcher();
        return matcher.match(pattern, group);
    }

    public static List<Group> filterMatching(List<Group> allGroups, String pattern) {
        return allGroups.stream().filter(grp -> GroupPatternMatcher.matches(grp.toString(), pattern)).collect(Collectors.toList());
    }

    public static List<Group> filterByIncludeGroupsMode(List<Group> allGroups, GroupRegistrationParam.IncludeGroupsMode mode) {
        if (mode.equals((Object)GroupRegistrationParam.IncludeGroupsMode.all)) {
            return allGroups;
        }
        return allGroups.stream().filter(g -> mode.equals((Object)GroupRegistrationParam.IncludeGroupsMode.publicOnly) ? g.isPublic() : !g.isPublic()).collect(Collectors.toList());
    }

    public static List<Group> filterMatching(List<Group> allGroups, Collection<String> filter) {
        Map<String, Group> groups = allGroups.stream().collect(Collectors.toMap(g -> g.toString(), g -> g));
        return filter.stream().filter(grp -> groups.containsKey(grp)).map(grp -> (Group)groups.get(grp)).collect(Collectors.toList());
    }

    public static boolean isValidPattern(String groupPath) {
        return groupPath.startsWith("/");
    }
}

