/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation.in;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pl.edu.icm.unity.engine.api.translation.in.EntityChange;
import pl.edu.icm.unity.engine.api.translation.in.MappedAttribute;
import pl.edu.icm.unity.engine.api.translation.in.MappedGroup;
import pl.edu.icm.unity.engine.api.translation.in.MappedIdentity;
import pl.edu.icm.unity.types.basic.EntityParam;

public class MappingResult {
    private List<MappedGroup> groups = new ArrayList<MappedGroup>();
    private List<MappedIdentity> identities = new ArrayList<MappedIdentity>();
    private List<MappedAttribute> attributes = new ArrayList<MappedAttribute>();
    private List<EntityChange> entityChanges = new ArrayList<EntityChange>();
    private EntityParam mappedAtExistingEntity;
    private Set<String> authenticatedWith = new HashSet<String>();
    private boolean cleanStaleGroups;
    private boolean cleanStaleAttributes;
    private boolean cleanStaleIdentities;

    public void addGroup(MappedGroup group) {
        this.groups.add(group);
    }

    public void addIdentity(MappedIdentity id) {
        this.identities.add(id);
    }

    public void addAttribute(MappedAttribute attr) {
        this.attributes.add(attr);
    }

    public void addEntityChange(EntityChange change) {
        this.entityChanges.add(change);
    }

    public List<MappedGroup> getGroups() {
        return this.groups;
    }

    public List<MappedIdentity> getIdentities() {
        return this.identities;
    }

    public List<MappedAttribute> getAttributes() {
        return this.attributes;
    }

    public List<EntityChange> getEntityChanges() {
        return this.entityChanges;
    }

    public boolean isCleanStaleGroups() {
        return this.cleanStaleGroups;
    }

    public void setCleanStaleGroups(boolean cleanStaleGroups) {
        this.cleanStaleGroups = cleanStaleGroups;
    }

    public boolean isCleanStaleAttributes() {
        return this.cleanStaleAttributes;
    }

    public void setCleanStaleAttributes(boolean cleanStaleAttributes) {
        this.cleanStaleAttributes = cleanStaleAttributes;
    }

    public boolean isCleanStaleIdentities() {
        return this.cleanStaleIdentities;
    }

    public void setCleanStaleIdentities(boolean cleanStaleIdentities) {
        this.cleanStaleIdentities = cleanStaleIdentities;
    }

    public EntityParam getMappedAtExistingEntity() {
        return this.mappedAtExistingEntity;
    }

    public void setMappedToExistingEntity(EntityParam mappedAtExistingEntity) {
        this.mappedAtExistingEntity = mappedAtExistingEntity;
    }

    public Set<String> getAuthenticatedWith() {
        return this.authenticatedWith;
    }

    public void addAuthenticatedWith(String authenticatedWith) {
        this.authenticatedWith.add(authenticatedWith);
    }

    public void mergeWith(MappingResult result) {
        this.groups.addAll(result.getGroups());
        this.identities.addAll(result.getIdentities());
        this.attributes.addAll(result.getAttributes());
        this.entityChanges.addAll(result.getEntityChanges());
        this.cleanStaleAttributes |= result.isCleanStaleAttributes();
        this.cleanStaleIdentities |= result.isCleanStaleIdentities();
        this.cleanStaleGroups |= result.isCleanStaleGroups();
        if (this.mappedAtExistingEntity == null) {
            this.mappedAtExistingEntity = result.mappedAtExistingEntity;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.authenticatedWith.isEmpty()) {
            sb.append("Authenticated with: ").append(this.authenticatedWith).append("\n");
        }
        if (!this.identities.isEmpty()) {
            sb.append("Identities:\n");
            for (MappedIdentity mappedIdentity : this.identities) {
                sb.append(" - ").append(mappedIdentity).append("\n");
            }
        }
        if (!this.entityChanges.isEmpty()) {
            sb.append("Entity changes:\n");
            for (EntityChange entityChange : this.entityChanges) {
                sb.append(" - ").append(entityChange).append("\n");
            }
        }
        if (this.mappedAtExistingEntity != null) {
            sb.append("Mapped at existing entity: ").append(this.mappedAtExistingEntity).append("\n");
        }
        if (!this.attributes.isEmpty()) {
            sb.append("Attributes:\n");
            for (MappedAttribute mappedAttribute : this.attributes) {
                sb.append(" - ").append(mappedAttribute).append("\n");
            }
        }
        if (!this.groups.isEmpty()) {
            sb.append("Groups:\n");
            for (MappedGroup mappedGroup : this.groups) {
                sb.append(" - ").append(mappedGroup).append("\n");
            }
        }
        sb.append("Cleaning stale groups: ").append(this.cleanStaleGroups).append(" attributes: ").append(this.cleanStaleAttributes).append(" identities: ").append(this.cleanStaleIdentities);
        return sb.toString();
    }
}

