/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import com.google.common.primitives.Chars;
import java.security.SecureRandom;
import java.util.Random;

public class CodeGenerator {
    private static final char[] LETTER_CHARS_POOL = new char[]{'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M'};
    private static final char[] NUMBER_CHARS_POOL = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static final char[] MIXED_CHARS_POOL = Chars.concat((char[][])new char[][]{LETTER_CHARS_POOL, NUMBER_CHARS_POOL});
    private static final Random rnd = new SecureRandom();

    public static String generateMixedCharCode(int codeLength) {
        return CodeGenerator.generateCode(codeLength, MIXED_CHARS_POOL);
    }

    public static String generateNumberCode(int codeLength) {
        return CodeGenerator.generateCode(codeLength, NUMBER_CHARS_POOL);
    }

    public static String generateCode(int codeLength, char[] pool) {
        char[] codeA = new char[codeLength];
        for (int i = 0; i < codeLength; ++i) {
            codeA[i] = pool[rnd.nextInt(pool.length)];
        }
        return new String(codeA);
    }
}

