/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;

public class FreemarkerUtils {
    public static final String TEMPLATES_ROOT = "/templates";
    private static final Logger log = Log.getLogger((String)"unity.server", FreemarkerUtils.class);

    public static TemplateLoader getTemplateLoader(String webContentsDirectory, String templatesRoot, Class<?> fallbackResourceLoaderClass) {
        FileTemplateLoader primaryLoader;
        ClassTemplateLoader fallbackLoader = new ClassTemplateLoader(fallbackResourceLoaderClass, templatesRoot);
        File webContents = new File(webContentsDirectory, templatesRoot);
        try {
            primaryLoader = new FileTemplateLoader(webContents);
        }
        catch (IOException e) {
            log.warn("Templates directory " + webContentsDirectory + " can not be read. Will use the default bundled templates only.");
            return fallbackLoader;
        }
        return new MultiTemplateLoader(new TemplateLoader[]{primaryLoader, fallbackLoader});
    }

    public static void processTemplate(Configuration cfg, String view, Map<String, String> datamodel, Writer out) throws IOException {
        Template temp = cfg.getTemplate(view);
        log.debug("Using template " + temp.getName());
        try {
            temp.process(datamodel, out);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
        out.flush();
    }
}

