/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import eu.unicore.util.configuration.ConfigurationException;
import java.util.Optional;
import pl.edu.icm.unity.engine.api.authn.AbstractVerificator;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAuthnResultProcessor;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteSandboxAuthnContext;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedContext;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.authn.remote.SandboxAuthnResultCallback;
import pl.edu.icm.unity.engine.api.config.UnityPropertiesHelper;
import pl.edu.icm.unity.engine.api.translation.TranslationProfileGenerator;
import pl.edu.icm.unity.engine.api.utils.LogRecorder;
import pl.edu.icm.unity.types.translation.TranslationProfile;

public abstract class AbstractRemoteVerificator
extends AbstractVerificator {
    private RemoteAuthnResultProcessor processor;

    public AbstractRemoteVerificator(String name, String description, String exchangeId, RemoteAuthnResultProcessor processor) {
        super(name, description, exchangeId);
        this.processor = processor;
    }

    protected AuthenticationResult getResult(RemotelyAuthenticatedInput input, TranslationProfile profile, RemoteAuthnState state) throws AuthenticationException {
        RemoteAuthnStateImpl stateCasted = (RemoteAuthnStateImpl)state;
        stateCasted.remoteInput = input;
        AuthenticationResult result = this.processor.getResult(input, profile, stateCasted.isInSandboxMode(), Optional.empty());
        this.finishAuthnResponseProcessing(state, result.getRemoteAuthnContext());
        return result;
    }

    protected RemoteAuthnState startAuthnResponseProcessing(SandboxAuthnResultCallback callback, String ... loggingFacilities) {
        RemoteAuthnStateImpl ret = new RemoteAuthnStateImpl(loggingFacilities, callback);
        return ret;
    }

    private void finishAuthnResponseProcessing(RemoteAuthnState state, RemotelyAuthenticatedContext context) {
        RemoteAuthnStateImpl stateCasted = (RemoteAuthnStateImpl)state;
        if (stateCasted.isInSandboxMode()) {
            LogRecorder recorder = stateCasted.logRecorder;
            recorder.stopLogRecording();
            stateCasted.sandboxCallback.sandboxedAuthenticationDone(new RemoteSandboxAuthnContext(context, recorder.getCapturedLogs().toString()));
        }
    }

    protected void finishAuthnResponseProcessing(RemoteAuthnState state, Exception error) {
        RemoteAuthnStateImpl stateCasted = (RemoteAuthnStateImpl)state;
        if (stateCasted.isInSandboxMode()) {
            LogRecorder recorder = stateCasted.logRecorder;
            recorder.stopLogRecording();
            stateCasted.sandboxCallback.sandboxedAuthenticationDone(new RemoteSandboxAuthnContext(error, recorder.getCapturedLogs().toString(), stateCasted.remoteInput));
        }
    }

    public static TranslationProfile getTranslationProfile(UnityPropertiesHelper props, String globalProfileNameKey, String embeddedProfileKey) throws ConfigurationException {
        if (props.isSet(embeddedProfileKey)) {
            return TranslationProfileGenerator.getProfileFromString(props.getValue(embeddedProfileKey));
        }
        if (props.getValue(globalProfileNameKey) != null) {
            return TranslationProfileGenerator.generateIncludeInputProfile(props.getValue(globalProfileNameKey));
        }
        throw new ConfigurationException("Translation profile is not set");
    }

    public static interface RemoteAuthnState {
    }

    private class RemoteAuthnStateImpl
    implements RemoteAuthnState {
        private LogRecorder logRecorder;
        private RemotelyAuthenticatedInput remoteInput;
        private SandboxAuthnResultCallback sandboxCallback;

        public RemoteAuthnStateImpl(String[] facilities, SandboxAuthnResultCallback sandboxCallback) {
            this.sandboxCallback = sandboxCallback;
            this.logRecorder = new LogRecorder(facilities);
            if (this.isInSandboxMode()) {
                this.logRecorder.startLogRecording();
            }
        }

        boolean isInSandboxMode() {
            return this.sandboxCallback != null;
        }
    }
}

