/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.endpoint;

import java.net.URL;
import pl.edu.icm.unity.engine.api.endpoint.AbstractEndpoint;
import pl.edu.icm.unity.engine.api.endpoint.WebAppEndpointInstance;
import pl.edu.icm.unity.engine.api.server.AdvertisedAddressProvider;
import pl.edu.icm.unity.engine.api.server.NetworkServer;
import pl.edu.icm.unity.exceptions.EngineException;

public abstract class AbstractWebEndpoint
extends AbstractEndpoint
implements WebAppEndpointInstance {
    protected final NetworkServer httpServer;
    protected final AdvertisedAddressProvider advertisedAddrProvider;

    public AbstractWebEndpoint(NetworkServer httpServer, AdvertisedAddressProvider advertisedAddrProvider) {
        this.httpServer = httpServer;
        this.advertisedAddrProvider = advertisedAddrProvider;
    }

    public URL getBaseUrl() {
        return this.advertisedAddrProvider.get();
    }

    public String getServletUrl(String servletPath) {
        return this.getBaseUrl().toExternalForm() + this.getEndpointDescription().getEndpoint().getContextAddress() + servletPath;
    }

    @Override
    public final void start() throws EngineException {
        this.startOverridable();
        this.httpServer.deployEndpoint(this);
    }

    protected void startOverridable() {
    }

    @Override
    public final void destroy() throws EngineException {
        super.destroy();
        this.httpServer.undeployEndpoint(this.getEndpointDescription().getEndpoint().getName());
        this.destroyOverridable();
    }

    protected void destroyOverridable() {
    }
}

