/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.mvel2.MVEL;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

public class TranslationCondition {
    private static final Logger log = Log.getLogger((String)"unity.server.externaltranslation", TranslationCondition.class);
    private String condition;
    private Serializable compiled;

    public TranslationCondition(String condition) {
        this.setCondition(condition);
    }

    public TranslationCondition() {
        this.setCondition("true");
    }

    public boolean evaluate(Object input) throws EngineException {
        return this.evaluateCondition(this.compiled, input, log);
    }

    public boolean evaluate(Object input, Logger log) throws EngineException {
        return this.evaluateCondition(this.compiled, input, log);
    }

    private boolean evaluateCondition(Serializable compiled, Object input, Logger log) throws EngineException {
        Boolean result = null;
        try {
            result = (Boolean)MVEL.executeExpression((Object)compiled, (Object)input, new HashMap());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Error during expression execution.", (Throwable)e);
            }
            throw new EngineException((Throwable)e);
        }
        if (result == null) {
            log.debug("Condition evaluated to null value, assuming false");
            return false;
        }
        return result;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
        this.compiled = MVEL.compileExpression((String)condition);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TranslationCondition other = (TranslationCondition)obj;
        return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
    }
}

