/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdPLoginController {
    private List<IdPLoginHandler> handlers = new ArrayList<IdPLoginHandler>();

    @Autowired
    public IdPLoginController(Optional<List<IdPLoginHandler>> handlers) {
        this.handlers = handlers.orElseGet(ArrayList::new);
    }

    public synchronized boolean isLoginInProgress() {
        for (IdPLoginHandler handler : this.handlers) {
            if (!handler.isLoginInProgress()) continue;
            return true;
        }
        return false;
    }

    public synchronized void breakLogin() {
        for (IdPLoginHandler handler : this.handlers) {
            handler.breakLogin();
        }
    }

    public static interface IdPLoginHandler {
        public boolean isLoginInProgress();

        public void breakLogin();
    }
}

