/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TypesRegistryBase<T> {
    private Map<String, T> elements = new HashMap<String, T>(10);

    public TypesRegistryBase(List<? extends T> typeElements) {
        if (typeElements == null) {
            typeElements = new ArrayList<T>();
        }
        for (T idDef : typeElements) {
            String id = this.getId(idDef);
            if (this.elements.containsKey(id)) {
                throw new IllegalStateException("Key " + id + " is used twice");
            }
            this.elements.put(id, idDef);
        }
    }

    public T getByName(String name) {
        T ret = this.elements.get(name);
        if (ret == null) {
            throw new IllegalArgumentException("Type " + name + " is not supported");
        }
        return ret;
    }

    public T getByNameOptional(String name) {
        return this.elements.get(name);
    }

    public Collection<T> getAll() {
        return this.elements.values();
    }

    protected abstract String getId(T var1);
}

