/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.registration;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import pl.edu.icm.unity.engine.api.endpoint.SharedEndpointManagement;
import pl.edu.icm.unity.types.registration.BaseForm;
import pl.edu.icm.unity.types.registration.RegistrationForm;

public class PublicRegistrationURLSupport {
    public static final String REGISTRATION_VIEW = "registration";
    public static final String ENQUIRY_VIEW = "enquiry";
    public static final String CODE_PARAM = "regcode";
    public static final String FORM_PARAM = "form";

    public static String getPublicRegistrationLink(RegistrationForm form, SharedEndpointManagement sharedEndpointMan) {
        String formName = form.getName();
        return sharedEndpointMan.getServletUrl("/pub") + "?" + FORM_PARAM + "=" + PublicRegistrationURLSupport.urlEncodePath(formName) + "#!" + REGISTRATION_VIEW;
    }

    public static String getWellknownEnquiryLink(String formName, SharedEndpointManagement sharedEndpointMan) {
        return sharedEndpointMan.getServerAddress() + "/well-known" + "/sec" + "?" + FORM_PARAM + "=" + PublicRegistrationURLSupport.urlEncodePath(formName) + "#!" + ENQUIRY_VIEW;
    }

    public static String getPublicRegistrationLink(BaseForm form, String code, SharedEndpointManagement sharedEndpointMan) {
        return sharedEndpointMan.getServletUrl("/pub") + "?" + CODE_PARAM + "=" + code + "&" + FORM_PARAM + "=" + PublicRegistrationURLSupport.urlEncodePath(form.getName()) + "#!" + REGISTRATION_VIEW;
    }

    public static String getPublicEnquiryLink(BaseForm form, String code, SharedEndpointManagement sharedEndpointMan) {
        return sharedEndpointMan.getServletUrl("/pub") + "?" + CODE_PARAM + "=" + code + "&" + FORM_PARAM + "=" + PublicRegistrationURLSupport.urlEncodePath(form.getName()) + "#!" + ENQUIRY_VIEW;
    }

    private static String urlEncodePath(String pathElement) {
        try {
            return URLEncoder.encode(pathElement, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

