/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;

public class AuthenticatedEntity {
    private Long entityId;
    private String outdatedCredentialId;
    private List<String> authenticatedWith;
    private String remoteIdP;

    public AuthenticatedEntity(Long entityId, AuthenticationSubject authnSubject, String outdatedCredentialId) {
        this(entityId, authnSubject.identity == null ? Collections.emptySet() : Collections.singleton(authnSubject.identity), outdatedCredentialId);
    }

    public AuthenticatedEntity(Long entityId, String info, String outdatedCredentialId) {
        this(entityId, Sets.newHashSet((Object[])new String[]{info}), outdatedCredentialId);
    }

    public AuthenticatedEntity(Long entityId, Set<String> info, String outdatedCredentialId) {
        Preconditions.checkNotNull((Object)entityId);
        this.entityId = entityId;
        this.authenticatedWith = new ArrayList<String>(4);
        this.authenticatedWith.addAll(info);
        this.setOutdatedCredentialId(outdatedCredentialId);
    }

    public String getRemoteIdP() {
        return this.remoteIdP;
    }

    public void setRemoteIdP(String remoteIdP) {
        this.remoteIdP = remoteIdP;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public List<String> getAuthenticatedWith() {
        return this.authenticatedWith;
    }

    public void setAuthenticatedWith(List<String> authenticatedWith) {
        this.authenticatedWith = authenticatedWith;
    }

    public String getOutdatedCredentialId() {
        return this.outdatedCredentialId;
    }

    public void setOutdatedCredentialId(String outdatedCredentialId) {
        this.outdatedCredentialId = outdatedCredentialId;
    }

    public String toString() {
        return String.format("AuthenticatedEntity [entityId=%s, outdatedCredentialId=%s, authenticatedWith=%s, remoteIdP=%s]", this.entityId, this.outdatedCredentialId, this.authenticatedWith, this.remoteIdP);
    }
}

