/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;

public class UnsuccessfulAuthenticationCounter {
    private static final Logger log = Log.getLogger((String)"unity.server.authn", UnsuccessfulAuthenticationCounter.class);
    private int maxAttepts;
    private long blockTime;
    private Map<String, ClientInfo> accessMap;

    public UnsuccessfulAuthenticationCounter(int maxAttepts, long blockTime) {
        this.maxAttepts = maxAttepts;
        this.blockTime = blockTime;
        this.accessMap = new HashMap<String, ClientInfo>(64);
    }

    public synchronized long getRemainingBlockedTime(String ip) {
        ClientInfo clientInfo = this.accessMap.get(ip);
        if (clientInfo == null || clientInfo.blockedStartTime == -1L) {
            return 0L;
        }
        long blockedFor = System.currentTimeMillis() - clientInfo.blockedStartTime;
        if (blockedFor >= this.blockTime) {
            this.accessMap.remove(ip);
            return 0L;
        }
        return this.blockTime - blockedFor;
    }

    public synchronized void unsuccessfulAttempt(String ip) {
        Preconditions.checkNotNull((Object)ip);
        ClientInfo clientInfo = this.accessMap.get(ip);
        if (clientInfo == null) {
            clientInfo = new ClientInfo();
            this.accessMap.put(ip, clientInfo);
        }
        clientInfo.unsuccessfulAttempts++;
        log.debug("Unsuccessful attempts count for {} is {}", (Object)ip, (Object)clientInfo.unsuccessfulAttempts);
        if (clientInfo.unsuccessfulAttempts >= this.maxAttepts) {
            log.info("Blocking access for IP {} after {} unsuccessful login attempts for {}ms", (Object)ip, (Object)clientInfo.unsuccessfulAttempts, (Object)this.blockTime);
            clientInfo.blockedStartTime = System.currentTimeMillis();
        }
    }

    public synchronized void successfulAttempt(String ip) {
        if (this.accessMap.containsKey(ip)) {
            log.info("Cleaning unsuccessful attempts for {}", (Object)ip);
        }
        this.accessMap.remove(ip);
    }

    private static class ClientInfo {
        private int unsuccessfulAttempts = 0;
        private long blockedStartTime = -1L;

        private ClientInfo() {
        }
    }
}

