/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.local;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificatorFactory;
import pl.edu.icm.unity.exceptions.IllegalCredentialException;
import pl.edu.icm.unity.types.authn.CredentialDefinition;
import pl.edu.icm.unity.types.authn.CredentialType;

@Component
public class LocalCredentialsRegistry {
    private Map<String, LocalCredentialVerificatorFactory> localCredentialVerificatorFactories;
    private Cache<CredentialDefinition, LocalCredentialVerificator> verificatorsCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).build();

    @Autowired
    public LocalCredentialsRegistry(Optional<List<LocalCredentialVerificatorFactory>> verificatorFactories) {
        this.localCredentialVerificatorFactories = new HashMap<String, LocalCredentialVerificatorFactory>();
        for (LocalCredentialVerificatorFactory f : verificatorFactories.orElseGet(ArrayList::new)) {
            this.localCredentialVerificatorFactories.put(f.getName(), f);
        }
    }

    public Set<CredentialType> getLocalCredentialTypes() {
        HashSet<CredentialType> ret = new HashSet<CredentialType>();
        for (LocalCredentialVerificatorFactory fact : this.localCredentialVerificatorFactories.values()) {
            CredentialType credentialType = new CredentialType(fact.getName(), fact.getDescription(), fact.isSupportingInvalidation());
            ret.add(credentialType);
        }
        return ret;
    }

    public LocalCredentialVerificatorFactory getLocalCredentialFactory(String id) {
        return this.localCredentialVerificatorFactories.get(id);
    }

    public LocalCredentialVerificator createLocalCredentialVerificator(CredentialDefinition def) throws IllegalCredentialException {
        LocalCredentialVerificator cached = (LocalCredentialVerificator)this.verificatorsCache.getIfPresent((Object)def);
        if (cached == null) {
            cached = this.createLocalCredentialVerificatorNoCache(def);
            this.verificatorsCache.put((Object)def, (Object)cached);
        }
        return cached;
    }

    private LocalCredentialVerificator createLocalCredentialVerificatorNoCache(CredentialDefinition def) throws IllegalCredentialException {
        LocalCredentialVerificatorFactory fact = this.getLocalCredentialFactory(def.getTypeId());
        if (fact == null) {
            throw new IllegalCredentialException("The credential type " + def.getTypeId() + " is unknown");
        }
        LocalCredentialVerificator validator = fact.newInstance();
        validator.setSerializedConfiguration(def.getConfiguration());
        validator.setCredentialName(def.getName());
        return validator;
    }
}

