/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import java.util.Date;
import java.util.UUID;
import java.util.function.Function;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.AuthenticationStepContext;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorStepContext;
import pl.edu.icm.unity.engine.api.authn.RememberMeToken;
import pl.edu.icm.unity.engine.api.authn.remote.AuthenticationTriggeringContext;

public class RemoteAuthnState {
    private final String relayState;
    private final Date creationTime;
    private final AuthenticationStepContext authenticationContext;
    private final RememberMeToken.LoginMachineDetails initialLoginMachine;
    private final String ultimateReturnURL;
    private final AuthenticationTriggeringContext authenticationTriggeringContext;
    private final Function<RemoteAuthnState, AuthenticationResult> responseHandler;

    public RemoteAuthnState(AuthenticationStepContext authenticationContext, Function<RemoteAuthnState, AuthenticationResult> responseHandler, RememberMeToken.LoginMachineDetails initialLoginMachine, String ultimateReturnURL, AuthenticationTriggeringContext authenticationTriggeringContext) {
        if (authenticationTriggeringContext.firstFactorAuthnState != null && authenticationContext.factor == AuthenticatorStepContext.FactorOrder.FIRST) {
            throw new IllegalArgumentException("Can't set first factor result for the first factor state");
        }
        if (authenticationTriggeringContext.firstFactorAuthnState == null && authenticationContext.factor == AuthenticatorStepContext.FactorOrder.SECOND) {
            throw new IllegalArgumentException("Must set first factor result for the second factor state");
        }
        this.authenticationContext = authenticationContext;
        this.responseHandler = responseHandler;
        this.initialLoginMachine = initialLoginMachine;
        this.ultimateReturnURL = ultimateReturnURL;
        this.authenticationTriggeringContext = authenticationTriggeringContext;
        this.relayState = UUID.randomUUID().toString();
        this.creationTime = new Date();
    }

    public RemoteAuthnState(RemoteAuthnState toCopy) {
        this(toCopy.authenticationContext, toCopy.responseHandler, toCopy.initialLoginMachine, toCopy.ultimateReturnURL, toCopy.authenticationTriggeringContext);
    }

    public AuthenticationTriggeringContext getAuthenticationTriggeringContext() {
        return this.authenticationTriggeringContext;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public AuthenticationStepContext getAuthenticationStepContext() {
        return this.authenticationContext;
    }

    public RememberMeToken.LoginMachineDetails getInitialLoginMachine() {
        return this.initialLoginMachine;
    }

    public String getUltimateReturnURL() {
        return this.ultimateReturnURL;
    }

    public AuthenticationResult processAnswer() {
        return this.responseHandler.apply(this);
    }
}

