/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedPrincipal;
import pl.edu.icm.unity.engine.api.authn.sandbox.SandboxAuthnContext;

public class RemoteSandboxAuthnContext
implements SandboxAuthnContext {
    private final RemotelyAuthenticatedPrincipal authnContext;
    private final Exception authnException;
    private final String logs;

    private RemoteSandboxAuthnContext(RemotelyAuthenticatedPrincipal authnContext, Exception authnException, String logs) {
        this.authnContext = authnContext;
        this.authnException = authnException;
        this.logs = logs;
    }

    public static RemoteSandboxAuthnContext succeededAuthn(RemotelyAuthenticatedPrincipal authnResult, String logs) {
        return new RemoteSandboxAuthnContext(authnResult, null, logs);
    }

    public static RemoteSandboxAuthnContext failedAuthn(Exception authnException, String logs, RemotelyAuthenticatedInput input) {
        RemotelyAuthenticatedPrincipal authnContext;
        if (input != null) {
            authnContext = new RemotelyAuthenticatedPrincipal(input.getIdpName(), null);
            authnContext.setAuthnInput(input);
        } else {
            authnContext = null;
        }
        return new RemoteSandboxAuthnContext(authnContext, authnException, logs);
    }

    @Override
    public RemotelyAuthenticatedPrincipal getAuthnContext() {
        return this.authnContext;
    }

    @Override
    public Exception getAuthnException() {
        return this.authnException;
    }

    @Override
    public String getLogs() {
        return this.logs;
    }
}

