/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.LocalAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthenticationResult;

public interface AuthenticationResult {
    public Status getStatus();

    public boolean isRemote();

    public String toStringFull();

    public SuccessResult getSuccessResult();

    public ErrorResult getErrorResult();

    default public RemoteAuthenticationResult asRemote() {
        if (!this.isRemote()) {
            throw new IllegalStateException("This is not a remote result");
        }
        return (RemoteAuthenticationResult)this;
    }

    default public LocalAuthenticationResult asLocal() {
        if (this.isRemote()) {
            throw new IllegalStateException("This is not a local result");
        }
        return (LocalAuthenticationResult)this;
    }

    public static class ResolvableError {
        static final ResolvableError EMPTY = new ResolvableError(null, new Object[0]);
        private final String errorCode;
        private final Object[] args;

        public ResolvableError(String errorCode, Object ... args) {
            this.errorCode = errorCode;
            this.args = args;
        }

        public String resovle(MessageSource msg) {
            return this.errorCode == null ? null : msg.getMessage(this.errorCode, this.args);
        }
    }

    public static class SuccessResult {
        public final AuthenticatedEntity authenticatedEntity;

        SuccessResult(AuthenticatedEntity authenticatedEntity) {
            this.authenticatedEntity = authenticatedEntity;
        }

        public String toString() {
            return String.format("[authenticatedEntity=%s]", this.authenticatedEntity);
        }
    }

    public static class ErrorResult {
        public final ResolvableError error;
        public final Exception cause;

        ErrorResult(ResolvableError error, Exception cause) {
            this.error = error;
            this.cause = cause;
        }

        public String toString() {
            return String.format("ErrorResult [error=%s, cause=%s]", this.error, this.cause);
        }
    }

    public static enum Status {
        notApplicable,
        deny,
        unknownRemotePrincipal,
        success;

    }
}

